/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.ConnectException;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactNotFoundException;
import software.amazon.awssdk.services.connect.model.CreateUserRequest;
import software.amazon.awssdk.services.connect.model.CreateUserResponse;
import software.amazon.awssdk.services.connect.model.DeleteUserRequest;
import software.amazon.awssdk.services.connect.model.DeleteUserResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserResponse;
import software.amazon.awssdk.services.connect.model.DestinationNotAllowedException;
import software.amazon.awssdk.services.connect.model.DuplicateResourceException;
import software.amazon.awssdk.services.connect.model.GetContactAttributesRequest;
import software.amazon.awssdk.services.connect.model.GetContactAttributesResponse;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse;
import software.amazon.awssdk.services.connect.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.connect.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.connect.model.GetMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetMetricDataResponse;
import software.amazon.awssdk.services.connect.model.InternalServiceException;
import software.amazon.awssdk.services.connect.model.InvalidParameterException;
import software.amazon.awssdk.services.connect.model.InvalidRequestException;
import software.amazon.awssdk.services.connect.model.LimitExceededException;
import software.amazon.awssdk.services.connect.model.ListContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowsResponse;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.ListQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse;
import software.amazon.awssdk.services.connect.model.ListUsersRequest;
import software.amazon.awssdk.services.connect.model.ListUsersResponse;
import software.amazon.awssdk.services.connect.model.OutboundContactNotPermittedException;
import software.amazon.awssdk.services.connect.model.ResourceNotFoundException;
import software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest;
import software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactResponse;
import software.amazon.awssdk.services.connect.model.StopContactRequest;
import software.amazon.awssdk.services.connect.model.StopContactResponse;
import software.amazon.awssdk.services.connect.model.ThrottlingException;
import software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactAttributesResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.UserNotFoundException;
import software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable;
import software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable;
import software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable;
import software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable;
import software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable;
import software.amazon.awssdk.services.connect.paginators.ListQueuesIterable;
import software.amazon.awssdk.services.connect.paginators.ListRoutingProfilesIterable;
import software.amazon.awssdk.services.connect.paginators.ListSecurityProfilesIterable;
import software.amazon.awssdk.services.connect.paginators.ListUserHierarchyGroupsIterable;
import software.amazon.awssdk.services.connect.paginators.ListUsersIterable;
import software.amazon.awssdk.services.connect.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeUserHierarchyGroupRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeUserHierarchyStructureRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetContactAttributesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetCurrentMetricDataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetFederationTokenRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetMetricDataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListContactFlowsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListHoursOfOperationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListPhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListQueuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListRoutingProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListSecurityProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListUserHierarchyGroupsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartOutboundVoiceContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StopContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactAttributesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserHierarchyRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserIdentityInfoRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserPhoneConfigRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserRoutingProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserSecurityProfilesRequestMarshaller;

@SdkInternalApi
final class DefaultConnectClient
implements ConnectClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConnectClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "connect";
    }

    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws InvalidRequestException, InvalidParameterException, LimitExceededException, DuplicateResourceException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserRequest).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserRequest).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserRequest).withMarshaller((Marshaller)new DescribeUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeUserHierarchyGroupResponse describeUserHierarchyGroup(DescribeUserHierarchyGroupRequest describeUserHierarchyGroupRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserHierarchyGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeUserHierarchyGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUserHierarchyGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserHierarchyGroupRequest).withMarshaller((Marshaller)new DescribeUserHierarchyGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeUserHierarchyStructureResponse describeUserHierarchyStructure(DescribeUserHierarchyStructureRequest describeUserHierarchyStructureRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserHierarchyStructureResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeUserHierarchyStructureResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUserHierarchyStructure").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserHierarchyStructureRequest).withMarshaller((Marshaller)new DescribeUserHierarchyStructureRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetContactAttributesResponse getContactAttributes(GetContactAttributesRequest getContactAttributesRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContactAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetContactAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContactAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getContactAttributesRequest).withMarshaller((Marshaller)new GetContactAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCurrentMetricDataResponse getCurrentMetricData(GetCurrentMetricDataRequest getCurrentMetricDataRequest) throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCurrentMetricDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetCurrentMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCurrentMetricData").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCurrentMetricDataRequest).withMarshaller((Marshaller)new GetCurrentMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCurrentMetricDataIterable getCurrentMetricDataPaginator(GetCurrentMetricDataRequest getCurrentMetricDataRequest) throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return new GetCurrentMetricDataIterable(this, this.applyPaginatorUserAgent(getCurrentMetricDataRequest));
    }

    @Override
    public GetFederationTokenResponse getFederationToken(GetFederationTokenRequest getFederationTokenRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, UserNotFoundException, InternalServiceException, DuplicateResourceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFederationTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetFederationTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFederationToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFederationTokenRequest).withMarshaller((Marshaller)new GetFederationTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetMetricDataResponse getMetricData(GetMetricDataRequest getMetricDataRequest) throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMetricDataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricData").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMetricDataRequest).withMarshaller((Marshaller)new GetMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetMetricDataIterable getMetricDataPaginator(GetMetricDataRequest getMetricDataRequest) throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return new GetMetricDataIterable(this, this.applyPaginatorUserAgent(getMetricDataRequest));
    }

    @Override
    public ListContactFlowsResponse listContactFlows(ListContactFlowsRequest listContactFlowsRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContactFlowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListContactFlowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContactFlows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listContactFlowsRequest).withMarshaller((Marshaller)new ListContactFlowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListContactFlowsIterable listContactFlowsPaginator(ListContactFlowsRequest listContactFlowsRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListContactFlowsIterable(this, this.applyPaginatorUserAgent(listContactFlowsRequest));
    }

    @Override
    public ListHoursOfOperationsResponse listHoursOfOperations(ListHoursOfOperationsRequest listHoursOfOperationsRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHoursOfOperationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListHoursOfOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHoursOfOperations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHoursOfOperationsRequest).withMarshaller((Marshaller)new ListHoursOfOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListHoursOfOperationsIterable listHoursOfOperationsPaginator(ListHoursOfOperationsRequest listHoursOfOperationsRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListHoursOfOperationsIterable(this, this.applyPaginatorUserAgent(listHoursOfOperationsRequest));
    }

    @Override
    public ListPhoneNumbersResponse listPhoneNumbers(ListPhoneNumbersRequest listPhoneNumbersRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPhoneNumbersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPhoneNumbersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPhoneNumbers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPhoneNumbersRequest).withMarshaller((Marshaller)new ListPhoneNumbersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPhoneNumbersIterable listPhoneNumbersPaginator(ListPhoneNumbersRequest listPhoneNumbersRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListPhoneNumbersIterable(this, this.applyPaginatorUserAgent(listPhoneNumbersRequest));
    }

    @Override
    public ListQueuesResponse listQueues(ListQueuesRequest listQueuesRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQueuesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListQueuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueues").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQueuesRequest).withMarshaller((Marshaller)new ListQueuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListQueuesIterable listQueuesPaginator(ListQueuesRequest listQueuesRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListQueuesIterable(this, this.applyPaginatorUserAgent(listQueuesRequest));
    }

    @Override
    public ListRoutingProfilesResponse listRoutingProfiles(ListRoutingProfilesRequest listRoutingProfilesRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRoutingProfilesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRoutingProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRoutingProfiles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRoutingProfilesRequest).withMarshaller((Marshaller)new ListRoutingProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRoutingProfilesIterable listRoutingProfilesPaginator(ListRoutingProfilesRequest listRoutingProfilesRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListRoutingProfilesIterable(this, this.applyPaginatorUserAgent(listRoutingProfilesRequest));
    }

    @Override
    public ListSecurityProfilesResponse listSecurityProfiles(ListSecurityProfilesRequest listSecurityProfilesRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSecurityProfilesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListSecurityProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSecurityProfiles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSecurityProfilesRequest).withMarshaller((Marshaller)new ListSecurityProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListSecurityProfilesIterable listSecurityProfilesPaginator(ListSecurityProfilesRequest listSecurityProfilesRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListSecurityProfilesIterable(this, this.applyPaginatorUserAgent(listSecurityProfilesRequest));
    }

    @Override
    public ListUserHierarchyGroupsResponse listUserHierarchyGroups(ListUserHierarchyGroupsRequest listUserHierarchyGroupsRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUserHierarchyGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListUserHierarchyGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUserHierarchyGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUserHierarchyGroupsRequest).withMarshaller((Marshaller)new ListUserHierarchyGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListUserHierarchyGroupsIterable listUserHierarchyGroupsPaginator(ListUserHierarchyGroupsRequest listUserHierarchyGroupsRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListUserHierarchyGroupsIterable(this, this.applyPaginatorUserAgent(listUserHierarchyGroupsRequest));
    }

    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsersRequest).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListUsersIterable(this, this.applyPaginatorUserAgent(listUsersRequest));
    }

    @Override
    public StartOutboundVoiceContactResponse startOutboundVoiceContact(StartOutboundVoiceContactRequest startOutboundVoiceContactRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException, LimitExceededException, DestinationNotAllowedException, OutboundContactNotPermittedException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartOutboundVoiceContactResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartOutboundVoiceContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartOutboundVoiceContact").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startOutboundVoiceContactRequest).withMarshaller((Marshaller)new StartOutboundVoiceContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopContactResponse stopContact(StopContactRequest stopContactRequest) throws InvalidRequestException, ContactNotFoundException, InvalidParameterException, ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopContactResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopContact").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopContactRequest).withMarshaller((Marshaller)new StopContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateContactAttributesResponse updateContactAttributes(UpdateContactAttributesRequest updateContactAttributesRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContactAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateContactAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContactAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateContactAttributesRequest).withMarshaller((Marshaller)new UpdateContactAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateUserHierarchyResponse updateUserHierarchy(UpdateUserHierarchyRequest updateUserHierarchyRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserHierarchyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateUserHierarchyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserHierarchy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserHierarchyRequest).withMarshaller((Marshaller)new UpdateUserHierarchyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateUserIdentityInfoResponse updateUserIdentityInfo(UpdateUserIdentityInfoRequest updateUserIdentityInfoRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserIdentityInfoResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateUserIdentityInfoResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserIdentityInfo").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserIdentityInfoRequest).withMarshaller((Marshaller)new UpdateUserIdentityInfoRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateUserPhoneConfigResponse updateUserPhoneConfig(UpdateUserPhoneConfigRequest updateUserPhoneConfigRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserPhoneConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateUserPhoneConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserPhoneConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserPhoneConfigRequest).withMarshaller((Marshaller)new UpdateUserPhoneConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateUserRoutingProfileResponse updateUserRoutingProfile(UpdateUserRoutingProfileRequest updateUserRoutingProfileRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserRoutingProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateUserRoutingProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserRoutingProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserRoutingProfileRequest).withMarshaller((Marshaller)new UpdateUserRoutingProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateUserSecurityProfilesResponse updateUserSecurityProfiles(UpdateUserSecurityProfilesRequest updateUserSecurityProfilesRequest) throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserSecurityProfilesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateUserSecurityProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserSecurityProfiles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserSecurityProfilesRequest).withMarshaller((Marshaller)new UpdateUserSecurityProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ConnectException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException").exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ContactNotFoundException").exceptionBuilderSupplier(ContactNotFoundException::builder).httpStatusCode(Integer.valueOf(410)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateResourceException").exceptionBuilderSupplier(DuplicateResourceException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserNotFoundException").exceptionBuilderSupplier(UserNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").exceptionBuilderSupplier(DestinationNotAllowedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ConnectRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.4").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ConnectRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

