/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactFlowType;
import software.amazon.awssdk.services.connect.model.ContactFlowTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactFlowsRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, ListContactFlowsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListContactFlowsRequest.getter(ListContactFlowsRequest::instanceId)).setter(ListContactFlowsRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<List<String>> CONTACT_FLOW_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListContactFlowsRequest.getter(ListContactFlowsRequest::contactFlowTypesAsStrings)).setter(ListContactFlowsRequest.setter(Builder::contactFlowTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("contactFlowTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListContactFlowsRequest.getter(ListContactFlowsRequest::nextToken)).setter(ListContactFlowsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListContactFlowsRequest.getter(ListContactFlowsRequest::maxResults)).setter(ListContactFlowsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_FLOW_TYPES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String instanceId;
    private final List<String> contactFlowTypes;
    private final String nextToken;
    private final Integer maxResults;

    private ListContactFlowsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactFlowTypes = builder.contactFlowTypes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<ContactFlowType> contactFlowTypes() {
        return ContactFlowTypesCopier.copyStringToEnum(this.contactFlowTypes);
    }

    public List<String> contactFlowTypesAsStrings() {
        return this.contactFlowTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactFlowsRequest)) {
            return false;
        }
        ListContactFlowsRequest other = (ListContactFlowsRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactFlowTypesAsStrings(), other.contactFlowTypesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListContactFlowsRequest").add("InstanceId", (Object)this.instanceId()).add("ContactFlowTypes", this.contactFlowTypesAsStrings()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactFlowTypes": {
                return Optional.ofNullable(clazz.cast(this.contactFlowTypesAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactFlowsRequest, T> g) {
        return obj -> g.apply((ListContactFlowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private List<String> contactFlowTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactFlowsRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactFlowTypesWithStrings(model.contactFlowTypes);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getContactFlowTypesAsStrings() {
            return this.contactFlowTypes;
        }

        @Override
        public final Builder contactFlowTypesWithStrings(Collection<String> contactFlowTypes) {
            this.contactFlowTypes = ContactFlowTypesCopier.copy(contactFlowTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlowTypesWithStrings(String ... contactFlowTypes) {
            this.contactFlowTypesWithStrings(Arrays.asList(contactFlowTypes));
            return this;
        }

        @Override
        public final Builder contactFlowTypes(Collection<ContactFlowType> contactFlowTypes) {
            this.contactFlowTypes = ContactFlowTypesCopier.copyEnumToString(contactFlowTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlowTypes(ContactFlowType ... contactFlowTypes) {
            this.contactFlowTypes(Arrays.asList(contactFlowTypes));
            return this;
        }

        public final void setContactFlowTypesWithStrings(Collection<String> contactFlowTypes) {
            this.contactFlowTypes = ContactFlowTypesCopier.copy(contactFlowTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContactFlowsRequest build() {
            return new ListContactFlowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContactFlowsRequest> {
        public Builder instanceId(String var1);

        public Builder contactFlowTypesWithStrings(Collection<String> var1);

        public Builder contactFlowTypesWithStrings(String ... var1);

        public Builder contactFlowTypes(Collection<ContactFlowType> var1);

        public Builder contactFlowTypes(ContactFlowType ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

