/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.RecorderStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationRecorderStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationRecorderStatus> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::name)).setter(ConfigurationRecorderStatus.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastStartTime)).setter(ConfigurationRecorderStatus.setter(Builder::lastStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()}).build();
    private static final SdkField<Instant> LAST_STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastStopTime)).setter(ConfigurationRecorderStatus.setter(Builder::lastStopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStopTime").build()}).build();
    private static final SdkField<Boolean> RECORDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::recording)).setter(ConfigurationRecorderStatus.setter(Builder::recording)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recording").build()}).build();
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastStatusAsString)).setter(ConfigurationRecorderStatus.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()}).build();
    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastErrorCode)).setter(ConfigurationRecorderStatus.setter(Builder::lastErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorCode").build()}).build();
    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastErrorMessage)).setter(ConfigurationRecorderStatus.setter(Builder::lastErrorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorMessage").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_CHANGE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastStatusChangeTime)).setter(ConfigurationRecorderStatus.setter(Builder::lastStatusChangeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChangeTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LAST_START_TIME_FIELD, LAST_STOP_TIME_FIELD, RECORDING_FIELD, LAST_STATUS_FIELD, LAST_ERROR_CODE_FIELD, LAST_ERROR_MESSAGE_FIELD, LAST_STATUS_CHANGE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Instant lastStartTime;
    private final Instant lastStopTime;
    private final Boolean recording;
    private final String lastStatus;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Instant lastStatusChangeTime;

    private ConfigurationRecorderStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.lastStartTime = builder.lastStartTime;
        this.lastStopTime = builder.lastStopTime;
        this.recording = builder.recording;
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
    }

    public String name() {
        return this.name;
    }

    public Instant lastStartTime() {
        return this.lastStartTime;
    }

    public Instant lastStopTime() {
        return this.lastStopTime;
    }

    public Boolean recording() {
        return this.recording;
    }

    public RecorderStatus lastStatus() {
        return RecorderStatus.fromValue(this.lastStatus);
    }

    public String lastStatusAsString() {
        return this.lastStatus;
    }

    public String lastErrorCode() {
        return this.lastErrorCode;
    }

    public String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Instant lastStatusChangeTime() {
        return this.lastStatusChangeTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recording());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusChangeTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderStatus)) {
            return false;
        }
        ConfigurationRecorderStatus other = (ConfigurationRecorderStatus)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.lastStartTime(), other.lastStartTime()) && Objects.equals(this.lastStopTime(), other.lastStopTime()) && Objects.equals(this.recording(), other.recording()) && Objects.equals(this.lastStatusAsString(), other.lastStatusAsString()) && Objects.equals(this.lastErrorCode(), other.lastErrorCode()) && Objects.equals(this.lastErrorMessage(), other.lastErrorMessage()) && Objects.equals(this.lastStatusChangeTime(), other.lastStatusChangeTime());
    }

    public String toString() {
        return ToString.builder((String)"ConfigurationRecorderStatus").add("Name", (Object)this.name()).add("LastStartTime", (Object)this.lastStartTime()).add("LastStopTime", (Object)this.lastStopTime()).add("Recording", (Object)this.recording()).add("LastStatus", (Object)this.lastStatusAsString()).add("LastErrorCode", (Object)this.lastErrorCode()).add("LastErrorMessage", (Object)this.lastErrorMessage()).add("LastStatusChangeTime", (Object)this.lastStatusChangeTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "lastStartTime": {
                return Optional.ofNullable(clazz.cast(this.lastStartTime()));
            }
            case "lastStopTime": {
                return Optional.ofNullable(clazz.cast(this.lastStopTime()));
            }
            case "recording": {
                return Optional.ofNullable(clazz.cast(this.recording()));
            }
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatusAsString()));
            }
            case "lastErrorCode": {
                return Optional.ofNullable(clazz.cast(this.lastErrorCode()));
            }
            case "lastErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.lastErrorMessage()));
            }
            case "lastStatusChangeTime": {
                return Optional.ofNullable(clazz.cast(this.lastStatusChangeTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorderStatus, T> g) {
        return obj -> g.apply((ConfigurationRecorderStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Instant lastStartTime;
        private Instant lastStopTime;
        private Boolean recording;
        private String lastStatus;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Instant lastStatusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderStatus model) {
            this.name(model.name);
            this.lastStartTime(model.lastStartTime);
            this.lastStopTime(model.lastStopTime);
            this.recording(model.recording);
            this.lastStatus(model.lastStatus);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
            this.lastStatusChangeTime(model.lastStatusChangeTime);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getLastStartTime() {
            return this.lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        public final Instant getLastStopTime() {
            return this.lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        public final Boolean getRecording() {
            return this.recording;
        }

        @Override
        public final Builder recording(Boolean recording) {
            this.recording = recording;
            return this;
        }

        public final void setRecording(Boolean recording) {
            this.recording = recording;
        }

        public final String getLastStatusAsString() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(RecorderStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastStatusChangeTime() {
            return this.lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        public ConfigurationRecorderStatus build() {
            return new ConfigurationRecorderStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationRecorderStatus> {
        public Builder name(String var1);

        public Builder lastStartTime(Instant var1);

        public Builder lastStopTime(Instant var1);

        public Builder recording(Boolean var1);

        public Builder lastStatus(String var1);

        public Builder lastStatus(RecorderStatus var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder lastStatusChangeTime(Instant var1);
    }
}

