/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ResourceCountFilters;
import software.amazon.awssdk.services.config.model.ResourceCountGroupKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAggregateDiscoveredResourceCountsRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, GetAggregateDiscoveredResourceCountsRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAggregateDiscoveredResourceCountsRequest.getter(GetAggregateDiscoveredResourceCountsRequest::configurationAggregatorName)).setter(GetAggregateDiscoveredResourceCountsRequest.setter(Builder::configurationAggregatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName").build()}).build();
    private static final SdkField<ResourceCountFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetAggregateDiscoveredResourceCountsRequest.getter(GetAggregateDiscoveredResourceCountsRequest::filters)).setter(GetAggregateDiscoveredResourceCountsRequest.setter(Builder::filters)).constructor(ResourceCountFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<String> GROUP_BY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAggregateDiscoveredResourceCountsRequest.getter(GetAggregateDiscoveredResourceCountsRequest::groupByKeyAsString)).setter(GetAggregateDiscoveredResourceCountsRequest.setter(Builder::groupByKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByKey").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetAggregateDiscoveredResourceCountsRequest.getter(GetAggregateDiscoveredResourceCountsRequest::limit)).setter(GetAggregateDiscoveredResourceCountsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAggregateDiscoveredResourceCountsRequest.getter(GetAggregateDiscoveredResourceCountsRequest::nextToken)).setter(GetAggregateDiscoveredResourceCountsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_AGGREGATOR_NAME_FIELD, FILTERS_FIELD, GROUP_BY_KEY_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final String configurationAggregatorName;
    private final ResourceCountFilters filters;
    private final String groupByKey;
    private final Integer limit;
    private final String nextToken;

    private GetAggregateDiscoveredResourceCountsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.filters = builder.filters;
        this.groupByKey = builder.groupByKey;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String configurationAggregatorName() {
        return this.configurationAggregatorName;
    }

    public ResourceCountFilters filters() {
        return this.filters;
    }

    public ResourceCountGroupKey groupByKey() {
        return ResourceCountGroupKey.fromValue(this.groupByKey);
    }

    public String groupByKeyAsString() {
        return this.groupByKey;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateDiscoveredResourceCountsRequest)) {
            return false;
        }
        GetAggregateDiscoveredResourceCountsRequest other = (GetAggregateDiscoveredResourceCountsRequest)((Object)obj);
        return Objects.equals(this.configurationAggregatorName(), other.configurationAggregatorName()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.groupByKeyAsString(), other.groupByKeyAsString()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetAggregateDiscoveredResourceCountsRequest").add("ConfigurationAggregatorName", (Object)this.configurationAggregatorName()).add("Filters", (Object)this.filters()).add("GroupByKey", (Object)this.groupByKeyAsString()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregatorName": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorName()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "GroupByKey": {
                return Optional.ofNullable(clazz.cast(this.groupByKeyAsString()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateDiscoveredResourceCountsRequest, T> g) {
        return obj -> g.apply((GetAggregateDiscoveredResourceCountsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configurationAggregatorName;
        private ResourceCountFilters filters;
        private String groupByKey;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateDiscoveredResourceCountsRequest model) {
            super(model);
            this.configurationAggregatorName(model.configurationAggregatorName);
            this.filters(model.filters);
            this.groupByKey(model.groupByKey);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final ResourceCountFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(ResourceCountFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(ResourceCountFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final String getGroupByKeyAsString() {
            return this.groupByKey;
        }

        @Override
        public final Builder groupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
            return this;
        }

        @Override
        public final Builder groupByKey(ResourceCountGroupKey groupByKey) {
            this.groupByKey(groupByKey.toString());
            return this;
        }

        public final void setGroupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAggregateDiscoveredResourceCountsRequest build() {
            return new GetAggregateDiscoveredResourceCountsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAggregateDiscoveredResourceCountsRequest> {
        public Builder configurationAggregatorName(String var1);

        public Builder filters(ResourceCountFilters var1);

        default public Builder filters(Consumer<ResourceCountFilters.Builder> filters) {
            return this.filters((ResourceCountFilters)((ResourceCountFilters.Builder)ResourceCountFilters.builder().applyMutation(filters)).build());
        }

        public Builder groupByKey(String var1);

        public Builder groupByKey(ResourceCountGroupKey var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

