/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.RetentionConfiguration;
import software.amazon.awssdk.services.config.model.RetentionConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRetentionConfigurationsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeRetentionConfigurationsResponse> {
    private static final SdkField<List<RetentionConfiguration>> RETENTION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeRetentionConfigurationsResponse.getter(DescribeRetentionConfigurationsResponse::retentionConfigurations)).setter(DescribeRetentionConfigurationsResponse.setter(Builder::retentionConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RetentionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeRetentionConfigurationsResponse.getter(DescribeRetentionConfigurationsResponse::nextToken)).setter(DescribeRetentionConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RetentionConfiguration> retentionConfigurations;
    private final String nextToken;

    private DescribeRetentionConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.retentionConfigurations = builder.retentionConfigurations;
        this.nextToken = builder.nextToken;
    }

    public List<RetentionConfiguration> retentionConfigurations() {
        return this.retentionConfigurations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRetentionConfigurationsResponse)) {
            return false;
        }
        DescribeRetentionConfigurationsResponse other = (DescribeRetentionConfigurationsResponse)((Object)obj);
        return Objects.equals(this.retentionConfigurations(), other.retentionConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRetentionConfigurationsResponse").add("RetentionConfigurations", this.retentionConfigurations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetentionConfigurations": {
                return Optional.ofNullable(clazz.cast(this.retentionConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRetentionConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeRetentionConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<RetentionConfiguration> retentionConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRetentionConfigurationsResponse model) {
            super(model);
            this.retentionConfigurations(model.retentionConfigurations);
            this.nextToken(model.nextToken);
        }

        public final Collection<RetentionConfiguration.Builder> getRetentionConfigurations() {
            return this.retentionConfigurations != null ? (Collection)this.retentionConfigurations.stream().map(RetentionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder retentionConfigurations(Collection<RetentionConfiguration> retentionConfigurations) {
            this.retentionConfigurations = RetentionConfigurationListCopier.copy(retentionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionConfigurations(RetentionConfiguration ... retentionConfigurations) {
            this.retentionConfigurations(Arrays.asList(retentionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionConfigurations(Consumer<RetentionConfiguration.Builder> ... retentionConfigurations) {
            this.retentionConfigurations(Stream.of(retentionConfigurations).map(c -> (RetentionConfiguration)((RetentionConfiguration.Builder)RetentionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRetentionConfigurations(Collection<RetentionConfiguration.BuilderImpl> retentionConfigurations) {
            this.retentionConfigurations = RetentionConfigurationListCopier.copyFromBuilder(retentionConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRetentionConfigurationsResponse build() {
            return new DescribeRetentionConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRetentionConfigurationsResponse> {
        public Builder retentionConfigurations(Collection<RetentionConfiguration> var1);

        public Builder retentionConfigurations(RetentionConfiguration ... var1);

        public Builder retentionConfigurations(Consumer<RetentionConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

