/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRuleState;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.services.config.model.Scope;
import software.amazon.awssdk.services.config.model.Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigRule> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRule.getter(ConfigRule::configRuleName)).setter(ConfigRule.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<String> CONFIG_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRule.getter(ConfigRule::configRuleArn)).setter(ConfigRule.setter(Builder::configRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleArn").build()}).build();
    private static final SdkField<String> CONFIG_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRule.getter(ConfigRule::configRuleId)).setter(ConfigRule.setter(Builder::configRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRule.getter(ConfigRule::description)).setter(ConfigRule.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Scope> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ConfigRule.getter(ConfigRule::scope)).setter(ConfigRule.setter(Builder::scope)).constructor(Scope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ConfigRule.getter(ConfigRule::source)).setter(ConfigRule.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRule.getter(ConfigRule::inputParameters)).setter(ConfigRule.setter(Builder::inputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputParameters").build()}).build();
    private static final SdkField<String> MAXIMUM_EXECUTION_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRule.getter(ConfigRule::maximumExecutionFrequencyAsString)).setter(ConfigRule.setter(Builder::maximumExecutionFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionFrequency").build()}).build();
    private static final SdkField<String> CONFIG_RULE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRule.getter(ConfigRule::configRuleStateAsString)).setter(ConfigRule.setter(Builder::configRuleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleState").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConfigRule.getter(ConfigRule::createdBy)).setter(ConfigRule.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, CONFIG_RULE_ARN_FIELD, CONFIG_RULE_ID_FIELD, DESCRIPTION_FIELD, SCOPE_FIELD, SOURCE_FIELD, INPUT_PARAMETERS_FIELD, MAXIMUM_EXECUTION_FREQUENCY_FIELD, CONFIG_RULE_STATE_FIELD, CREATED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configRuleName;
    private final String configRuleArn;
    private final String configRuleId;
    private final String description;
    private final Scope scope;
    private final Source source;
    private final String inputParameters;
    private final String maximumExecutionFrequency;
    private final String configRuleState;
    private final String createdBy;

    private ConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.configRuleArn = builder.configRuleArn;
        this.configRuleId = builder.configRuleId;
        this.description = builder.description;
        this.scope = builder.scope;
        this.source = builder.source;
        this.inputParameters = builder.inputParameters;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
        this.configRuleState = builder.configRuleState;
        this.createdBy = builder.createdBy;
    }

    public String configRuleName() {
        return this.configRuleName;
    }

    public String configRuleArn() {
        return this.configRuleArn;
    }

    public String configRuleId() {
        return this.configRuleId;
    }

    public String description() {
        return this.description;
    }

    public Scope scope() {
        return this.scope;
    }

    public Source source() {
        return this.source;
    }

    public String inputParameters() {
        return this.inputParameters;
    }

    public MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(this.maximumExecutionFrequency);
    }

    public String maximumExecutionFrequencyAsString() {
        return this.maximumExecutionFrequency;
    }

    public ConfigRuleState configRuleState() {
        return ConfigRuleState.fromValue(this.configRuleState);
    }

    public String configRuleStateAsString() {
        return this.configRuleState;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumExecutionFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRule)) {
            return false;
        }
        ConfigRule other = (ConfigRule)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.configRuleArn(), other.configRuleArn()) && Objects.equals(this.configRuleId(), other.configRuleId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.inputParameters(), other.inputParameters()) && Objects.equals(this.maximumExecutionFrequencyAsString(), other.maximumExecutionFrequencyAsString()) && Objects.equals(this.configRuleStateAsString(), other.configRuleStateAsString()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public String toString() {
        return ToString.builder((String)"ConfigRule").add("ConfigRuleName", (Object)this.configRuleName()).add("ConfigRuleArn", (Object)this.configRuleArn()).add("ConfigRuleId", (Object)this.configRuleId()).add("Description", (Object)this.description()).add("Scope", (Object)this.scope()).add("Source", (Object)this.source()).add("InputParameters", (Object)this.inputParameters()).add("MaximumExecutionFrequency", (Object)this.maximumExecutionFrequencyAsString()).add("ConfigRuleState", (Object)this.configRuleStateAsString()).add("CreatedBy", (Object)this.createdBy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ConfigRuleArn": {
                return Optional.ofNullable(clazz.cast(this.configRuleArn()));
            }
            case "ConfigRuleId": {
                return Optional.ofNullable(clazz.cast(this.configRuleId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "InputParameters": {
                return Optional.ofNullable(clazz.cast(this.inputParameters()));
            }
            case "MaximumExecutionFrequency": {
                return Optional.ofNullable(clazz.cast(this.maximumExecutionFrequencyAsString()));
            }
            case "ConfigRuleState": {
                return Optional.ofNullable(clazz.cast(this.configRuleStateAsString()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigRule, T> g) {
        return obj -> g.apply((ConfigRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String configRuleArn;
        private String configRuleId;
        private String description;
        private Scope scope;
        private Source source;
        private String inputParameters;
        private String maximumExecutionFrequency;
        private String configRuleState;
        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRule model) {
            this.configRuleName(model.configRuleName);
            this.configRuleArn(model.configRuleArn);
            this.configRuleId(model.configRuleId);
            this.description(model.description);
            this.scope(model.scope);
            this.source(model.source);
            this.inputParameters(model.inputParameters);
            this.maximumExecutionFrequency(model.maximumExecutionFrequency);
            this.configRuleState(model.configRuleState);
            this.createdBy(model.createdBy);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getConfigRuleArn() {
            return this.configRuleArn;
        }

        @Override
        public final Builder configRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
            return this;
        }

        public final void setConfigRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
        }

        public final String getConfigRuleId() {
            return this.configRuleId;
        }

        @Override
        public final Builder configRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
            return this;
        }

        public final void setConfigRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Scope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final String getInputParameters() {
            return this.inputParameters;
        }

        @Override
        public final Builder inputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public final void setInputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
        }

        public final String getMaximumExecutionFrequencyAsString() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency.toString());
            return this;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        public final String getConfigRuleStateAsString() {
            return this.configRuleState;
        }

        @Override
        public final Builder configRuleState(String configRuleState) {
            this.configRuleState = configRuleState;
            return this;
        }

        @Override
        public final Builder configRuleState(ConfigRuleState configRuleState) {
            this.configRuleState(configRuleState.toString());
            return this;
        }

        public final void setConfigRuleState(String configRuleState) {
            this.configRuleState = configRuleState;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public ConfigRule build() {
            return new ConfigRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigRule> {
        public Builder configRuleName(String var1);

        public Builder configRuleArn(String var1);

        public Builder configRuleId(String var1);

        public Builder description(String var1);

        public Builder scope(Scope var1);

        default public Builder scope(Consumer<Scope.Builder> scope) {
            return this.scope((Scope)((Scope.Builder)Scope.builder().applyMutation(scope)).build());
        }

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder inputParameters(String var1);

        public Builder maximumExecutionFrequency(String var1);

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency var1);

        public Builder configRuleState(String var1);

        public Builder configRuleState(ConfigRuleState var1);

        public Builder createdBy(String var1);
    }
}

