/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AccountAggregationSourceAccountListCopier;
import software.amazon.awssdk.services.config.model.AggregatorRegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountAggregationSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountAggregationSource> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AccountAggregationSource.getter(AccountAggregationSource::accountIds)).setter(AccountAggregationSource.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALL_AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AccountAggregationSource.getter(AccountAggregationSource::allAwsRegions)).setter(AccountAggregationSource.setter(Builder::allAwsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllAwsRegions").build()}).build();
    private static final SdkField<List<String>> AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AccountAggregationSource.getter(AccountAggregationSource::awsRegions)).setter(AccountAggregationSource.setter(Builder::awsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, ALL_AWS_REGIONS_FIELD, AWS_REGIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> accountIds;
    private final Boolean allAwsRegions;
    private final List<String> awsRegions;

    private AccountAggregationSource(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.allAwsRegions = builder.allAwsRegions;
        this.awsRegions = builder.awsRegions;
    }

    public List<String> accountIds() {
        return this.accountIds;
    }

    public Boolean allAwsRegions() {
        return this.allAwsRegions;
    }

    public List<String> awsRegions() {
        return this.awsRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.allAwsRegions());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAggregationSource)) {
            return false;
        }
        AccountAggregationSource other = (AccountAggregationSource)obj;
        return Objects.equals(this.accountIds(), other.accountIds()) && Objects.equals(this.allAwsRegions(), other.allAwsRegions()) && Objects.equals(this.awsRegions(), other.awsRegions());
    }

    public String toString() {
        return ToString.builder((String)"AccountAggregationSource").add("AccountIds", this.accountIds()).add("AllAwsRegions", (Object)this.allAwsRegions()).add("AwsRegions", this.awsRegions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "AllAwsRegions": {
                return Optional.ofNullable(clazz.cast(this.allAwsRegions()));
            }
            case "AwsRegions": {
                return Optional.ofNullable(clazz.cast(this.awsRegions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountAggregationSource, T> g) {
        return obj -> g.apply((AccountAggregationSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean allAwsRegions;
        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAggregationSource model) {
            this.accountIds(model.accountIds);
            this.allAwsRegions(model.allAwsRegions);
            this.awsRegions(model.awsRegions);
        }

        public final Collection<String> getAccountIds() {
            return this.accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountAggregationSourceAccountListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountAggregationSourceAccountListCopier.copy(accountIds);
        }

        public final Boolean getAllAwsRegions() {
            return this.allAwsRegions;
        }

        @Override
        public final Builder allAwsRegions(Boolean allAwsRegions) {
            this.allAwsRegions = allAwsRegions;
            return this;
        }

        public final void setAllAwsRegions(Boolean allAwsRegions) {
            this.allAwsRegions = allAwsRegions;
        }

        public final Collection<String> getAwsRegions() {
            return this.awsRegions;
        }

        @Override
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = AggregatorRegionListCopier.copy(awsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsRegions(String ... awsRegions) {
            this.awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = AggregatorRegionListCopier.copy(awsRegions);
        }

        public AccountAggregationSource build() {
            return new AccountAggregationSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountAggregationSource> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder allAwsRegions(Boolean var1);

        public Builder awsRegions(Collection<String> var1);

        public Builder awsRegions(String ... var1);
    }
}

