/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.RetentionConfigurationNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRetentionConfigurationsRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeRetentionConfigurationsRequest> {
    private static final SdkField<List<String>> RETENTION_CONFIGURATION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeRetentionConfigurationsRequest.getter(DescribeRetentionConfigurationsRequest::retentionConfigurationNames)).setter(DescribeRetentionConfigurationsRequest.setter(Builder::retentionConfigurationNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionConfigurationNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeRetentionConfigurationsRequest.getter(DescribeRetentionConfigurationsRequest::nextToken)).setter(DescribeRetentionConfigurationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_CONFIGURATION_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> retentionConfigurationNames;
    private final String nextToken;

    private DescribeRetentionConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.retentionConfigurationNames = builder.retentionConfigurationNames;
        this.nextToken = builder.nextToken;
    }

    public List<String> retentionConfigurationNames() {
        return this.retentionConfigurationNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionConfigurationNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRetentionConfigurationsRequest)) {
            return false;
        }
        DescribeRetentionConfigurationsRequest other = (DescribeRetentionConfigurationsRequest)((Object)obj);
        return Objects.equals(this.retentionConfigurationNames(), other.retentionConfigurationNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRetentionConfigurationsRequest").add("RetentionConfigurationNames", this.retentionConfigurationNames()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetentionConfigurationNames": {
                return Optional.ofNullable(clazz.cast(this.retentionConfigurationNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRetentionConfigurationsRequest, T> g) {
        return obj -> g.apply((DescribeRetentionConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<String> retentionConfigurationNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRetentionConfigurationsRequest model) {
            super(model);
            this.retentionConfigurationNames(model.retentionConfigurationNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getRetentionConfigurationNames() {
            return this.retentionConfigurationNames;
        }

        @Override
        public final Builder retentionConfigurationNames(Collection<String> retentionConfigurationNames) {
            this.retentionConfigurationNames = RetentionConfigurationNameListCopier.copy(retentionConfigurationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retentionConfigurationNames(String ... retentionConfigurationNames) {
            this.retentionConfigurationNames(Arrays.asList(retentionConfigurationNames));
            return this;
        }

        public final void setRetentionConfigurationNames(Collection<String> retentionConfigurationNames) {
            this.retentionConfigurationNames = RetentionConfigurationNameListCopier.copy(retentionConfigurationNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRetentionConfigurationsRequest build() {
            return new DescribeRetentionConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRetentionConfigurationsRequest> {
        public Builder retentionConfigurationNames(Collection<String> var1);

        public Builder retentionConfigurationNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

