/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConfigRule;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;

public class DescribeConfigRulesPublisher
implements SdkPublisher<DescribeConfigRulesResponse> {
    private final ConfigAsyncClient client;
    private final DescribeConfigRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConfigRulesPublisher(ConfigAsyncClient client, DescribeConfigRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConfigRulesPublisher(ConfigAsyncClient client, DescribeConfigRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConfigRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConfigRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigRule> configRules() {
        Function<DescribeConfigRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.configRules() != null) {
                return response.configRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeConfigRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeConfigRulesResponseFetcher
    implements AsyncPageFetcher<DescribeConfigRulesResponse> {
        private DescribeConfigRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeConfigRulesResponse> nextPage(DescribeConfigRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigRulesPublisher.this.client.describeConfigRules(DescribeConfigRulesPublisher.this.firstRequest);
            }
            return DescribeConfigRulesPublisher.this.client.describeConfigRules((DescribeConfigRulesRequest)((Object)DescribeConfigRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

