/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRuleState;
import software.amazon.awssdk.services.config.model.EvaluationModeConfiguration;
import software.amazon.awssdk.services.config.model.EvaluationModesCopier;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.services.config.model.Scope;
import software.amazon.awssdk.services.config.model.Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigRule> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(ConfigRule.getter(ConfigRule::configRuleName)).setter(ConfigRule.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<String> CONFIG_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleArn").getter(ConfigRule.getter(ConfigRule::configRuleArn)).setter(ConfigRule.setter(Builder::configRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleArn").build()}).build();
    private static final SdkField<String> CONFIG_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleId").getter(ConfigRule.getter(ConfigRule::configRuleId)).setter(ConfigRule.setter(Builder::configRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ConfigRule.getter(ConfigRule::description)).setter(ConfigRule.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Scope> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Scope").getter(ConfigRule.getter(ConfigRule::scope)).setter(ConfigRule.setter(Builder::scope)).constructor(Scope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(ConfigRule.getter(ConfigRule::source)).setter(ConfigRule.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputParameters").getter(ConfigRule.getter(ConfigRule::inputParameters)).setter(ConfigRule.setter(Builder::inputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputParameters").build()}).build();
    private static final SdkField<String> MAXIMUM_EXECUTION_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaximumExecutionFrequency").getter(ConfigRule.getter(ConfigRule::maximumExecutionFrequencyAsString)).setter(ConfigRule.setter(Builder::maximumExecutionFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionFrequency").build()}).build();
    private static final SdkField<String> CONFIG_RULE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleState").getter(ConfigRule.getter(ConfigRule::configRuleStateAsString)).setter(ConfigRule.setter(Builder::configRuleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleState").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(ConfigRule.getter(ConfigRule::createdBy)).setter(ConfigRule.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<List<EvaluationModeConfiguration>> EVALUATION_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EvaluationModes").getter(ConfigRule.getter(ConfigRule::evaluationModes)).setter(ConfigRule.setter(Builder::evaluationModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationModeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, CONFIG_RULE_ARN_FIELD, CONFIG_RULE_ID_FIELD, DESCRIPTION_FIELD, SCOPE_FIELD, SOURCE_FIELD, INPUT_PARAMETERS_FIELD, MAXIMUM_EXECUTION_FREQUENCY_FIELD, CONFIG_RULE_STATE_FIELD, CREATED_BY_FIELD, EVALUATION_MODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configRuleName;
    private final String configRuleArn;
    private final String configRuleId;
    private final String description;
    private final Scope scope;
    private final Source source;
    private final String inputParameters;
    private final String maximumExecutionFrequency;
    private final String configRuleState;
    private final String createdBy;
    private final List<EvaluationModeConfiguration> evaluationModes;

    private ConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.configRuleArn = builder.configRuleArn;
        this.configRuleId = builder.configRuleId;
        this.description = builder.description;
        this.scope = builder.scope;
        this.source = builder.source;
        this.inputParameters = builder.inputParameters;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
        this.configRuleState = builder.configRuleState;
        this.createdBy = builder.createdBy;
        this.evaluationModes = builder.evaluationModes;
    }

    public final String configRuleName() {
        return this.configRuleName;
    }

    public final String configRuleArn() {
        return this.configRuleArn;
    }

    public final String configRuleId() {
        return this.configRuleId;
    }

    public final String description() {
        return this.description;
    }

    public final Scope scope() {
        return this.scope;
    }

    public final Source source() {
        return this.source;
    }

    public final String inputParameters() {
        return this.inputParameters;
    }

    public final MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(this.maximumExecutionFrequency);
    }

    public final String maximumExecutionFrequencyAsString() {
        return this.maximumExecutionFrequency;
    }

    public final ConfigRuleState configRuleState() {
        return ConfigRuleState.fromValue(this.configRuleState);
    }

    public final String configRuleStateAsString() {
        return this.configRuleState;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final boolean hasEvaluationModes() {
        return this.evaluationModes != null && !(this.evaluationModes instanceof SdkAutoConstructList);
    }

    public final List<EvaluationModeConfiguration> evaluationModes() {
        return this.evaluationModes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumExecutionFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationModes() ? this.evaluationModes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRule)) {
            return false;
        }
        ConfigRule other = (ConfigRule)obj;
        return Objects.equals(this.configRuleName(), other.configRuleName()) && Objects.equals(this.configRuleArn(), other.configRuleArn()) && Objects.equals(this.configRuleId(), other.configRuleId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.inputParameters(), other.inputParameters()) && Objects.equals(this.maximumExecutionFrequencyAsString(), other.maximumExecutionFrequencyAsString()) && Objects.equals(this.configRuleStateAsString(), other.configRuleStateAsString()) && Objects.equals(this.createdBy(), other.createdBy()) && this.hasEvaluationModes() == other.hasEvaluationModes() && Objects.equals(this.evaluationModes(), other.evaluationModes());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigRule").add("ConfigRuleName", (Object)this.configRuleName()).add("ConfigRuleArn", (Object)this.configRuleArn()).add("ConfigRuleId", (Object)this.configRuleId()).add("Description", (Object)this.description()).add("Scope", (Object)this.scope()).add("Source", (Object)this.source()).add("InputParameters", (Object)this.inputParameters()).add("MaximumExecutionFrequency", (Object)this.maximumExecutionFrequencyAsString()).add("ConfigRuleState", (Object)this.configRuleStateAsString()).add("CreatedBy", (Object)this.createdBy()).add("EvaluationModes", this.hasEvaluationModes() ? this.evaluationModes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ConfigRuleArn": {
                return Optional.ofNullable(clazz.cast(this.configRuleArn()));
            }
            case "ConfigRuleId": {
                return Optional.ofNullable(clazz.cast(this.configRuleId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "InputParameters": {
                return Optional.ofNullable(clazz.cast(this.inputParameters()));
            }
            case "MaximumExecutionFrequency": {
                return Optional.ofNullable(clazz.cast(this.maximumExecutionFrequencyAsString()));
            }
            case "ConfigRuleState": {
                return Optional.ofNullable(clazz.cast(this.configRuleStateAsString()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "EvaluationModes": {
                return Optional.ofNullable(clazz.cast(this.evaluationModes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigRuleName", CONFIG_RULE_NAME_FIELD);
        map.put("ConfigRuleArn", CONFIG_RULE_ARN_FIELD);
        map.put("ConfigRuleId", CONFIG_RULE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("InputParameters", INPUT_PARAMETERS_FIELD);
        map.put("MaximumExecutionFrequency", MAXIMUM_EXECUTION_FREQUENCY_FIELD);
        map.put("ConfigRuleState", CONFIG_RULE_STATE_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("EvaluationModes", EVALUATION_MODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigRule, T> g) {
        return obj -> g.apply((ConfigRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configRuleName;
        private String configRuleArn;
        private String configRuleId;
        private String description;
        private Scope scope;
        private Source source;
        private String inputParameters;
        private String maximumExecutionFrequency;
        private String configRuleState;
        private String createdBy;
        private List<EvaluationModeConfiguration> evaluationModes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRule model) {
            this.configRuleName(model.configRuleName);
            this.configRuleArn(model.configRuleArn);
            this.configRuleId(model.configRuleId);
            this.description(model.description);
            this.scope(model.scope);
            this.source(model.source);
            this.inputParameters(model.inputParameters);
            this.maximumExecutionFrequency(model.maximumExecutionFrequency);
            this.configRuleState(model.configRuleState);
            this.createdBy(model.createdBy);
            this.evaluationModes(model.evaluationModes);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final String getConfigRuleArn() {
            return this.configRuleArn;
        }

        public final void setConfigRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
        }

        @Override
        public final Builder configRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
            return this;
        }

        public final String getConfigRuleId() {
            return this.configRuleId;
        }

        public final void setConfigRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
        }

        @Override
        public final Builder configRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Scope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final String getInputParameters() {
            return this.inputParameters;
        }

        public final void setInputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
        }

        @Override
        public final Builder inputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public final String getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency == null ? null : maximumExecutionFrequency.toString());
            return this;
        }

        public final String getConfigRuleState() {
            return this.configRuleState;
        }

        public final void setConfigRuleState(String configRuleState) {
            this.configRuleState = configRuleState;
        }

        @Override
        public final Builder configRuleState(String configRuleState) {
            this.configRuleState = configRuleState;
            return this;
        }

        @Override
        public final Builder configRuleState(ConfigRuleState configRuleState) {
            this.configRuleState(configRuleState == null ? null : configRuleState.toString());
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final List<EvaluationModeConfiguration.Builder> getEvaluationModes() {
            List<EvaluationModeConfiguration.Builder> result = EvaluationModesCopier.copyToBuilder(this.evaluationModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationModes(Collection<EvaluationModeConfiguration.BuilderImpl> evaluationModes) {
            this.evaluationModes = EvaluationModesCopier.copyFromBuilder(evaluationModes);
        }

        @Override
        public final Builder evaluationModes(Collection<EvaluationModeConfiguration> evaluationModes) {
            this.evaluationModes = EvaluationModesCopier.copy(evaluationModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationModes(EvaluationModeConfiguration ... evaluationModes) {
            this.evaluationModes(Arrays.asList(evaluationModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationModes(Consumer<EvaluationModeConfiguration.Builder> ... evaluationModes) {
            this.evaluationModes(Stream.of(evaluationModes).map(c -> (EvaluationModeConfiguration)((EvaluationModeConfiguration.Builder)EvaluationModeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConfigRule build() {
            return new ConfigRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigRule> {
        public Builder configRuleName(String var1);

        public Builder configRuleArn(String var1);

        public Builder configRuleId(String var1);

        public Builder description(String var1);

        public Builder scope(Scope var1);

        default public Builder scope(Consumer<Scope.Builder> scope) {
            return this.scope((Scope)((Scope.Builder)Scope.builder().applyMutation(scope)).build());
        }

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder inputParameters(String var1);

        public Builder maximumExecutionFrequency(String var1);

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency var1);

        public Builder configRuleState(String var1);

        public Builder configRuleState(ConfigRuleState var1);

        public Builder createdBy(String var1);

        public Builder evaluationModes(Collection<EvaluationModeConfiguration> var1);

        public Builder evaluationModes(EvaluationModeConfiguration ... var1);

        public Builder evaluationModes(Consumer<EvaluationModeConfiguration.Builder> ... var1);
    }
}

