/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.OrganizationResourceDetailedStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationConformancePackDetailedStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationConformancePackDetailedStatus> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(OrganizationConformancePackDetailedStatus.getter(OrganizationConformancePackDetailedStatus::accountId)).setter(OrganizationConformancePackDetailedStatus.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConformancePackName").getter(OrganizationConformancePackDetailedStatus.getter(OrganizationConformancePackDetailedStatus::conformancePackName)).setter(OrganizationConformancePackDetailedStatus.setter(Builder::conformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(OrganizationConformancePackDetailedStatus.getter(OrganizationConformancePackDetailedStatus::statusAsString)).setter(OrganizationConformancePackDetailedStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(OrganizationConformancePackDetailedStatus.getter(OrganizationConformancePackDetailedStatus::errorCode)).setter(OrganizationConformancePackDetailedStatus.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(OrganizationConformancePackDetailedStatus.getter(OrganizationConformancePackDetailedStatus::errorMessage)).setter(OrganizationConformancePackDetailedStatus.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(OrganizationConformancePackDetailedStatus.getter(OrganizationConformancePackDetailedStatus::lastUpdateTime)).setter(OrganizationConformancePackDetailedStatus.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CONFORMANCE_PACK_NAME_FIELD, STATUS_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrganizationConformancePackDetailedStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String conformancePackName;
    private final String status;
    private final String errorCode;
    private final String errorMessage;
    private final Instant lastUpdateTime;

    private OrganizationConformancePackDetailedStatus(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.conformancePackName = builder.conformancePackName;
        this.status = builder.status;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String conformancePackName() {
        return this.conformancePackName;
    }

    public final OrganizationResourceDetailedStatus status() {
        return OrganizationResourceDetailedStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConformancePackDetailedStatus)) {
            return false;
        }
        OrganizationConformancePackDetailedStatus other = (OrganizationConformancePackDetailedStatus)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.conformancePackName(), other.conformancePackName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationConformancePackDetailedStatus").add("AccountId", (Object)this.accountId()).add("ConformancePackName", (Object)this.conformancePackName()).add("Status", (Object)this.statusAsString()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.conformancePackName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ConformancePackName", CONFORMANCE_PACK_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConformancePackDetailedStatus, T> g) {
        return obj -> g.apply((OrganizationConformancePackDetailedStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String conformancePackName;
        private String status;
        private String errorCode;
        private String errorMessage;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConformancePackDetailedStatus model) {
            this.accountId(model.accountId);
            this.conformancePackName(model.conformancePackName);
            this.status(model.status);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getConformancePackName() {
            return this.conformancePackName;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrganizationResourceDetailedStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public OrganizationConformancePackDetailedStatus build() {
            return new OrganizationConformancePackDetailedStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationConformancePackDetailedStatus> {
        public Builder accountId(String var1);

        public Builder conformancePackName(String var1);

        public Builder status(String var1);

        public Builder status(OrganizationResourceDetailedStatus var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

