/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StoredQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StoredQuery> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(StoredQuery.getter(StoredQuery::queryId)).setter(StoredQuery.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> QUERY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryArn").getter(StoredQuery.getter(StoredQuery::queryArn)).setter(StoredQuery.setter(Builder::queryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryArn").build()}).build();
    private static final SdkField<String> QUERY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryName").getter(StoredQuery.getter(StoredQuery::queryName)).setter(StoredQuery.setter(Builder::queryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StoredQuery.getter(StoredQuery::description)).setter(StoredQuery.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(StoredQuery.getter(StoredQuery::expression)).setter(StoredQuery.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, QUERY_ARN_FIELD, QUERY_NAME_FIELD, DESCRIPTION_FIELD, EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StoredQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queryId;
    private final String queryArn;
    private final String queryName;
    private final String description;
    private final String expression;

    private StoredQuery(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryArn = builder.queryArn;
        this.queryName = builder.queryName;
        this.description = builder.description;
        this.expression = builder.expression;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final String queryArn() {
        return this.queryArn;
    }

    public final String queryName() {
        return this.queryName;
    }

    public final String description() {
        return this.description;
    }

    public final String expression() {
        return this.expression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StoredQuery)) {
            return false;
        }
        StoredQuery other = (StoredQuery)obj;
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.queryArn(), other.queryArn()) && Objects.equals(this.queryName(), other.queryName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.expression(), other.expression());
    }

    public final String toString() {
        return ToString.builder((String)"StoredQuery").add("QueryId", (Object)this.queryId()).add("QueryArn", (Object)this.queryArn()).add("QueryName", (Object)this.queryName()).add("Description", (Object)this.description()).add("Expression", (Object)this.expression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "QueryArn": {
                return Optional.ofNullable(clazz.cast(this.queryArn()));
            }
            case "QueryName": {
                return Optional.ofNullable(clazz.cast(this.queryName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("QueryArn", QUERY_ARN_FIELD);
        map.put("QueryName", QUERY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StoredQuery, T> g) {
        return obj -> g.apply((StoredQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryId;
        private String queryArn;
        private String queryName;
        private String description;
        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(StoredQuery model) {
            this.queryId(model.queryId);
            this.queryArn(model.queryArn);
            this.queryName(model.queryName);
            this.description(model.description);
            this.expression(model.expression);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryArn() {
            return this.queryArn;
        }

        public final void setQueryArn(String queryArn) {
            this.queryArn = queryArn;
        }

        @Override
        public final Builder queryArn(String queryArn) {
            this.queryArn = queryArn;
            return this;
        }

        public final String getQueryName() {
            return this.queryName;
        }

        public final void setQueryName(String queryName) {
            this.queryName = queryName;
        }

        @Override
        public final Builder queryName(String queryName) {
            this.queryName = queryName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public StoredQuery build() {
            return new StoredQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StoredQuery> {
        public Builder queryId(String var1);

        public Builder queryArn(String var1);

        public Builder queryName(String var1);

        public Builder description(String var1);

        public Builder expression(String var1);
    }
}

