/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AccountAggregationSource;
import software.amazon.awssdk.services.config.model.AccountAggregationSourceListCopier;
import software.amazon.awssdk.services.config.model.AggregatorFilters;
import software.amazon.awssdk.services.config.model.OrganizationAggregationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationAggregator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationAggregator> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationAggregatorName").getter(ConfigurationAggregator.getter(ConfigurationAggregator::configurationAggregatorName)).setter(ConfigurationAggregator.setter(Builder::configurationAggregatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName").build()}).build();
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationAggregatorArn").getter(ConfigurationAggregator.getter(ConfigurationAggregator::configurationAggregatorArn)).setter(ConfigurationAggregator.setter(Builder::configurationAggregatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorArn").build()}).build();
    private static final SdkField<List<AccountAggregationSource>> ACCOUNT_AGGREGATION_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountAggregationSources").getter(ConfigurationAggregator.getter(ConfigurationAggregator::accountAggregationSources)).setter(ConfigurationAggregator.setter(Builder::accountAggregationSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAggregationSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountAggregationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OrganizationAggregationSource> ORGANIZATION_AGGREGATION_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationAggregationSource").getter(ConfigurationAggregator.getter(ConfigurationAggregator::organizationAggregationSource)).setter(ConfigurationAggregator.setter(Builder::organizationAggregationSource)).constructor(OrganizationAggregationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationAggregationSource").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ConfigurationAggregator.getter(ConfigurationAggregator::creationTime)).setter(ConfigurationAggregator.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(ConfigurationAggregator.getter(ConfigurationAggregator::lastUpdatedTime)).setter(ConfigurationAggregator.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(ConfigurationAggregator.getter(ConfigurationAggregator::createdBy)).setter(ConfigurationAggregator.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<AggregatorFilters> AGGREGATOR_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AggregatorFilters").getter(ConfigurationAggregator.getter(ConfigurationAggregator::aggregatorFilters)).setter(ConfigurationAggregator.setter(Builder::aggregatorFilters)).constructor(AggregatorFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorFilters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_AGGREGATOR_NAME_FIELD, CONFIGURATION_AGGREGATOR_ARN_FIELD, ACCOUNT_AGGREGATION_SOURCES_FIELD, ORGANIZATION_AGGREGATION_SOURCE_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_BY_FIELD, AGGREGATOR_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationAggregator.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configurationAggregatorName;
    private final String configurationAggregatorArn;
    private final List<AccountAggregationSource> accountAggregationSources;
    private final OrganizationAggregationSource organizationAggregationSource;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final String createdBy;
    private final AggregatorFilters aggregatorFilters;

    private ConfigurationAggregator(BuilderImpl builder) {
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.configurationAggregatorArn = builder.configurationAggregatorArn;
        this.accountAggregationSources = builder.accountAggregationSources;
        this.organizationAggregationSource = builder.organizationAggregationSource;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdBy = builder.createdBy;
        this.aggregatorFilters = builder.aggregatorFilters;
    }

    public final String configurationAggregatorName() {
        return this.configurationAggregatorName;
    }

    public final String configurationAggregatorArn() {
        return this.configurationAggregatorArn;
    }

    public final boolean hasAccountAggregationSources() {
        return this.accountAggregationSources != null && !(this.accountAggregationSources instanceof SdkAutoConstructList);
    }

    public final List<AccountAggregationSource> accountAggregationSources() {
        return this.accountAggregationSources;
    }

    public final OrganizationAggregationSource organizationAggregationSource() {
        return this.organizationAggregationSource;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final AggregatorFilters aggregatorFilters() {
        return this.aggregatorFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountAggregationSources() ? this.accountAggregationSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationAggregationSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatorFilters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationAggregator)) {
            return false;
        }
        ConfigurationAggregator other = (ConfigurationAggregator)obj;
        return Objects.equals(this.configurationAggregatorName(), other.configurationAggregatorName()) && Objects.equals(this.configurationAggregatorArn(), other.configurationAggregatorArn()) && this.hasAccountAggregationSources() == other.hasAccountAggregationSources() && Objects.equals(this.accountAggregationSources(), other.accountAggregationSources()) && Objects.equals(this.organizationAggregationSource(), other.organizationAggregationSource()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.aggregatorFilters(), other.aggregatorFilters());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationAggregator").add("ConfigurationAggregatorName", (Object)this.configurationAggregatorName()).add("ConfigurationAggregatorArn", (Object)this.configurationAggregatorArn()).add("AccountAggregationSources", this.hasAccountAggregationSources() ? this.accountAggregationSources() : null).add("OrganizationAggregationSource", (Object)this.organizationAggregationSource()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedBy", (Object)this.createdBy()).add("AggregatorFilters", (Object)this.aggregatorFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregatorName": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorName()));
            }
            case "ConfigurationAggregatorArn": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorArn()));
            }
            case "AccountAggregationSources": {
                return Optional.ofNullable(clazz.cast(this.accountAggregationSources()));
            }
            case "OrganizationAggregationSource": {
                return Optional.ofNullable(clazz.cast(this.organizationAggregationSource()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "AggregatorFilters": {
                return Optional.ofNullable(clazz.cast(this.aggregatorFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationAggregatorName", CONFIGURATION_AGGREGATOR_NAME_FIELD);
        map.put("ConfigurationAggregatorArn", CONFIGURATION_AGGREGATOR_ARN_FIELD);
        map.put("AccountAggregationSources", ACCOUNT_AGGREGATION_SOURCES_FIELD);
        map.put("OrganizationAggregationSource", ORGANIZATION_AGGREGATION_SOURCE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("AggregatorFilters", AGGREGATOR_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationAggregator, T> g) {
        return obj -> g.apply((ConfigurationAggregator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationAggregatorName;
        private String configurationAggregatorArn;
        private List<AccountAggregationSource> accountAggregationSources = DefaultSdkAutoConstructList.getInstance();
        private OrganizationAggregationSource organizationAggregationSource;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private String createdBy;
        private AggregatorFilters aggregatorFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationAggregator model) {
            this.configurationAggregatorName(model.configurationAggregatorName);
            this.configurationAggregatorArn(model.configurationAggregatorArn);
            this.accountAggregationSources(model.accountAggregationSources);
            this.organizationAggregationSource(model.organizationAggregationSource);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdBy(model.createdBy);
            this.aggregatorFilters(model.aggregatorFilters);
        }

        public final String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final String getConfigurationAggregatorArn() {
            return this.configurationAggregatorArn;
        }

        public final void setConfigurationAggregatorArn(String configurationAggregatorArn) {
            this.configurationAggregatorArn = configurationAggregatorArn;
        }

        @Override
        public final Builder configurationAggregatorArn(String configurationAggregatorArn) {
            this.configurationAggregatorArn = configurationAggregatorArn;
            return this;
        }

        public final List<AccountAggregationSource.Builder> getAccountAggregationSources() {
            List<AccountAggregationSource.Builder> result = AccountAggregationSourceListCopier.copyToBuilder(this.accountAggregationSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountAggregationSources(Collection<AccountAggregationSource.BuilderImpl> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copyFromBuilder(accountAggregationSources);
        }

        @Override
        public final Builder accountAggregationSources(Collection<AccountAggregationSource> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copy(accountAggregationSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAggregationSources(AccountAggregationSource ... accountAggregationSources) {
            this.accountAggregationSources(Arrays.asList(accountAggregationSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder> ... accountAggregationSources) {
            this.accountAggregationSources(Stream.of(accountAggregationSources).map(c -> (AccountAggregationSource)((AccountAggregationSource.Builder)AccountAggregationSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OrganizationAggregationSource.Builder getOrganizationAggregationSource() {
            return this.organizationAggregationSource != null ? this.organizationAggregationSource.toBuilder() : null;
        }

        public final void setOrganizationAggregationSource(OrganizationAggregationSource.BuilderImpl organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource != null ? organizationAggregationSource.build() : null;
        }

        @Override
        public final Builder organizationAggregationSource(OrganizationAggregationSource organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final AggregatorFilters.Builder getAggregatorFilters() {
            return this.aggregatorFilters != null ? this.aggregatorFilters.toBuilder() : null;
        }

        public final void setAggregatorFilters(AggregatorFilters.BuilderImpl aggregatorFilters) {
            this.aggregatorFilters = aggregatorFilters != null ? aggregatorFilters.build() : null;
        }

        @Override
        public final Builder aggregatorFilters(AggregatorFilters aggregatorFilters) {
            this.aggregatorFilters = aggregatorFilters;
            return this;
        }

        public ConfigurationAggregator build() {
            return new ConfigurationAggregator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationAggregator> {
        public Builder configurationAggregatorName(String var1);

        public Builder configurationAggregatorArn(String var1);

        public Builder accountAggregationSources(Collection<AccountAggregationSource> var1);

        public Builder accountAggregationSources(AccountAggregationSource ... var1);

        public Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder> ... var1);

        public Builder organizationAggregationSource(OrganizationAggregationSource var1);

        default public Builder organizationAggregationSource(Consumer<OrganizationAggregationSource.Builder> organizationAggregationSource) {
            return this.organizationAggregationSource((OrganizationAggregationSource)((OrganizationAggregationSource.Builder)OrganizationAggregationSource.builder().applyMutation(organizationAggregationSource)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder createdBy(String var1);

        public Builder aggregatorFilters(AggregatorFilters var1);

        default public Builder aggregatorFilters(Consumer<AggregatorFilters.Builder> aggregatorFilters) {
            return this.aggregatorFilters((AggregatorFilters)((AggregatorFilters.Builder)AggregatorFilters.builder().applyMutation(aggregatorFilters)).build());
        }
    }
}

