/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.EvaluationContext;
import software.amazon.awssdk.services.config.model.EvaluationMode;
import software.amazon.awssdk.services.config.model.EvaluationStatus;
import software.amazon.awssdk.services.config.model.ResourceDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceEvaluationSummaryResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetResourceEvaluationSummaryResponse> {
    private static final SdkField<String> RESOURCE_EVALUATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceEvaluationId").getter(GetResourceEvaluationSummaryResponse.getter(GetResourceEvaluationSummaryResponse::resourceEvaluationId)).setter(GetResourceEvaluationSummaryResponse.setter(Builder::resourceEvaluationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEvaluationId").build()}).build();
    private static final SdkField<String> EVALUATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationMode").getter(GetResourceEvaluationSummaryResponse.getter(GetResourceEvaluationSummaryResponse::evaluationModeAsString)).setter(GetResourceEvaluationSummaryResponse.setter(Builder::evaluationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMode").build()}).build();
    private static final SdkField<EvaluationStatus> EVALUATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationStatus").getter(GetResourceEvaluationSummaryResponse.getter(GetResourceEvaluationSummaryResponse::evaluationStatus)).setter(GetResourceEvaluationSummaryResponse.setter(Builder::evaluationStatus)).constructor(EvaluationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationStatus").build()}).build();
    private static final SdkField<Instant> EVALUATION_START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationStartTimestamp").getter(GetResourceEvaluationSummaryResponse.getter(GetResourceEvaluationSummaryResponse::evaluationStartTimestamp)).setter(GetResourceEvaluationSummaryResponse.setter(Builder::evaluationStartTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationStartTimestamp").build()}).build();
    private static final SdkField<String> COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Compliance").getter(GetResourceEvaluationSummaryResponse.getter(GetResourceEvaluationSummaryResponse::complianceAsString)).setter(GetResourceEvaluationSummaryResponse.setter(Builder::compliance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compliance").build()}).build();
    private static final SdkField<EvaluationContext> EVALUATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationContext").getter(GetResourceEvaluationSummaryResponse.getter(GetResourceEvaluationSummaryResponse::evaluationContext)).setter(GetResourceEvaluationSummaryResponse.setter(Builder::evaluationContext)).constructor(EvaluationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContext").build()}).build();
    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDetails").getter(GetResourceEvaluationSummaryResponse.getter(GetResourceEvaluationSummaryResponse::resourceDetails)).setter(GetResourceEvaluationSummaryResponse.setter(Builder::resourceDetails)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_EVALUATION_ID_FIELD, EVALUATION_MODE_FIELD, EVALUATION_STATUS_FIELD, EVALUATION_START_TIMESTAMP_FIELD, COMPLIANCE_FIELD, EVALUATION_CONTEXT_FIELD, RESOURCE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceEvaluationSummaryResponse.memberNameToFieldInitializer();
    private final String resourceEvaluationId;
    private final String evaluationMode;
    private final EvaluationStatus evaluationStatus;
    private final Instant evaluationStartTimestamp;
    private final String compliance;
    private final EvaluationContext evaluationContext;
    private final ResourceDetails resourceDetails;

    private GetResourceEvaluationSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.resourceEvaluationId = builder.resourceEvaluationId;
        this.evaluationMode = builder.evaluationMode;
        this.evaluationStatus = builder.evaluationStatus;
        this.evaluationStartTimestamp = builder.evaluationStartTimestamp;
        this.compliance = builder.compliance;
        this.evaluationContext = builder.evaluationContext;
        this.resourceDetails = builder.resourceDetails;
    }

    public final String resourceEvaluationId() {
        return this.resourceEvaluationId;
    }

    public final EvaluationMode evaluationMode() {
        return EvaluationMode.fromValue(this.evaluationMode);
    }

    public final String evaluationModeAsString() {
        return this.evaluationMode;
    }

    public final EvaluationStatus evaluationStatus() {
        return this.evaluationStatus;
    }

    public final Instant evaluationStartTimestamp() {
        return this.evaluationStartTimestamp;
    }

    public final ComplianceType compliance() {
        return ComplianceType.fromValue(this.compliance);
    }

    public final String complianceAsString() {
        return this.compliance;
    }

    public final EvaluationContext evaluationContext() {
        return this.evaluationContext;
    }

    public final ResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceEvaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceEvaluationSummaryResponse)) {
            return false;
        }
        GetResourceEvaluationSummaryResponse other = (GetResourceEvaluationSummaryResponse)((Object)obj);
        return Objects.equals(this.resourceEvaluationId(), other.resourceEvaluationId()) && Objects.equals(this.evaluationModeAsString(), other.evaluationModeAsString()) && Objects.equals(this.evaluationStatus(), other.evaluationStatus()) && Objects.equals(this.evaluationStartTimestamp(), other.evaluationStartTimestamp()) && Objects.equals(this.complianceAsString(), other.complianceAsString()) && Objects.equals(this.evaluationContext(), other.evaluationContext()) && Objects.equals(this.resourceDetails(), other.resourceDetails());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceEvaluationSummaryResponse").add("ResourceEvaluationId", (Object)this.resourceEvaluationId()).add("EvaluationMode", (Object)this.evaluationModeAsString()).add("EvaluationStatus", (Object)this.evaluationStatus()).add("EvaluationStartTimestamp", (Object)this.evaluationStartTimestamp()).add("Compliance", (Object)this.complianceAsString()).add("EvaluationContext", (Object)this.evaluationContext()).add("ResourceDetails", (Object)this.resourceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceEvaluationId": {
                return Optional.ofNullable(clazz.cast(this.resourceEvaluationId()));
            }
            case "EvaluationMode": {
                return Optional.ofNullable(clazz.cast(this.evaluationModeAsString()));
            }
            case "EvaluationStatus": {
                return Optional.ofNullable(clazz.cast(this.evaluationStatus()));
            }
            case "EvaluationStartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.evaluationStartTimestamp()));
            }
            case "Compliance": {
                return Optional.ofNullable(clazz.cast(this.complianceAsString()));
            }
            case "EvaluationContext": {
                return Optional.ofNullable(clazz.cast(this.evaluationContext()));
            }
            case "ResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceEvaluationId", RESOURCE_EVALUATION_ID_FIELD);
        map.put("EvaluationMode", EVALUATION_MODE_FIELD);
        map.put("EvaluationStatus", EVALUATION_STATUS_FIELD);
        map.put("EvaluationStartTimestamp", EVALUATION_START_TIMESTAMP_FIELD);
        map.put("Compliance", COMPLIANCE_FIELD);
        map.put("EvaluationContext", EVALUATION_CONTEXT_FIELD);
        map.put("ResourceDetails", RESOURCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceEvaluationSummaryResponse, T> g) {
        return obj -> g.apply((GetResourceEvaluationSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private String resourceEvaluationId;
        private String evaluationMode;
        private EvaluationStatus evaluationStatus;
        private Instant evaluationStartTimestamp;
        private String compliance;
        private EvaluationContext evaluationContext;
        private ResourceDetails resourceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceEvaluationSummaryResponse model) {
            super(model);
            this.resourceEvaluationId(model.resourceEvaluationId);
            this.evaluationMode(model.evaluationMode);
            this.evaluationStatus(model.evaluationStatus);
            this.evaluationStartTimestamp(model.evaluationStartTimestamp);
            this.compliance(model.compliance);
            this.evaluationContext(model.evaluationContext);
            this.resourceDetails(model.resourceDetails);
        }

        public final String getResourceEvaluationId() {
            return this.resourceEvaluationId;
        }

        public final void setResourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
        }

        @Override
        public final Builder resourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
            return this;
        }

        public final String getEvaluationMode() {
            return this.evaluationMode;
        }

        public final void setEvaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
        }

        @Override
        public final Builder evaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
            return this;
        }

        @Override
        public final Builder evaluationMode(EvaluationMode evaluationMode) {
            this.evaluationMode(evaluationMode == null ? null : evaluationMode.toString());
            return this;
        }

        public final EvaluationStatus.Builder getEvaluationStatus() {
            return this.evaluationStatus != null ? this.evaluationStatus.toBuilder() : null;
        }

        public final void setEvaluationStatus(EvaluationStatus.BuilderImpl evaluationStatus) {
            this.evaluationStatus = evaluationStatus != null ? evaluationStatus.build() : null;
        }

        @Override
        public final Builder evaluationStatus(EvaluationStatus evaluationStatus) {
            this.evaluationStatus = evaluationStatus;
            return this;
        }

        public final Instant getEvaluationStartTimestamp() {
            return this.evaluationStartTimestamp;
        }

        public final void setEvaluationStartTimestamp(Instant evaluationStartTimestamp) {
            this.evaluationStartTimestamp = evaluationStartTimestamp;
        }

        @Override
        public final Builder evaluationStartTimestamp(Instant evaluationStartTimestamp) {
            this.evaluationStartTimestamp = evaluationStartTimestamp;
            return this;
        }

        public final String getCompliance() {
            return this.compliance;
        }

        public final void setCompliance(String compliance) {
            this.compliance = compliance;
        }

        @Override
        public final Builder compliance(String compliance) {
            this.compliance = compliance;
            return this;
        }

        @Override
        public final Builder compliance(ComplianceType compliance) {
            this.compliance(compliance == null ? null : compliance.toString());
            return this;
        }

        public final EvaluationContext.Builder getEvaluationContext() {
            return this.evaluationContext != null ? this.evaluationContext.toBuilder() : null;
        }

        public final void setEvaluationContext(EvaluationContext.BuilderImpl evaluationContext) {
            this.evaluationContext = evaluationContext != null ? evaluationContext.build() : null;
        }

        @Override
        public final Builder evaluationContext(EvaluationContext evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return this.resourceDetails != null ? this.resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        @Override
        public GetResourceEvaluationSummaryResponse build() {
            return new GetResourceEvaluationSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceEvaluationSummaryResponse> {
        public Builder resourceEvaluationId(String var1);

        public Builder evaluationMode(String var1);

        public Builder evaluationMode(EvaluationMode var1);

        public Builder evaluationStatus(EvaluationStatus var1);

        default public Builder evaluationStatus(Consumer<EvaluationStatus.Builder> evaluationStatus) {
            return this.evaluationStatus((EvaluationStatus)((EvaluationStatus.Builder)EvaluationStatus.builder().applyMutation(evaluationStatus)).build());
        }

        public Builder evaluationStartTimestamp(Instant var1);

        public Builder compliance(String var1);

        public Builder compliance(ComplianceType var1);

        public Builder evaluationContext(EvaluationContext var1);

        default public Builder evaluationContext(Consumer<EvaluationContext.Builder> evaluationContext) {
            return this.evaluationContext((EvaluationContext)((EvaluationContext.Builder)EvaluationContext.builder().applyMutation(evaluationContext)).build());
        }

        public Builder resourceDetails(ResourceDetails var1);

        default public Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return this.resourceDetails((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(resourceDetails)).build());
        }
    }
}

