/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackStatus;

public class DescribeOrganizationConformancePackStatusesIterable
implements SdkIterable<DescribeOrganizationConformancePackStatusesResponse> {
    private final ConfigClient client;
    private final DescribeOrganizationConformancePackStatusesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOrganizationConformancePackStatusesIterable(ConfigClient client, DescribeOrganizationConformancePackStatusesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeOrganizationConformancePackStatusesResponseFetcher();
    }

    public Iterator<DescribeOrganizationConformancePackStatusesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OrganizationConformancePackStatus> organizationConformancePackStatuses() {
        Function<DescribeOrganizationConformancePackStatusesResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationConformancePackStatuses() != null) {
                return response.organizationConformancePackStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeOrganizationConformancePackStatusesResponseFetcher
    implements SyncPageFetcher<DescribeOrganizationConformancePackStatusesResponse> {
        private DescribeOrganizationConformancePackStatusesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrganizationConformancePackStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeOrganizationConformancePackStatusesResponse nextPage(DescribeOrganizationConformancePackStatusesResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrganizationConformancePackStatusesIterable.this.client.describeOrganizationConformancePackStatuses(DescribeOrganizationConformancePackStatusesIterable.this.firstRequest);
            }
            return DescribeOrganizationConformancePackStatusesIterable.this.client.describeOrganizationConformancePackStatuses((DescribeOrganizationConformancePackStatusesRequest)((Object)DescribeOrganizationConformancePackStatusesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

