/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateConformancePackCompliance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateConformancePackCompliance> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(AggregateConformancePackCompliance.getter(AggregateConformancePackCompliance::complianceTypeAsString)).setter(AggregateConformancePackCompliance.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<Integer> COMPLIANT_RULE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CompliantRuleCount").getter(AggregateConformancePackCompliance.getter(AggregateConformancePackCompliance::compliantRuleCount)).setter(AggregateConformancePackCompliance.setter(Builder::compliantRuleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantRuleCount").build()}).build();
    private static final SdkField<Integer> NON_COMPLIANT_RULE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NonCompliantRuleCount").getter(AggregateConformancePackCompliance.getter(AggregateConformancePackCompliance::nonCompliantRuleCount)).setter(AggregateConformancePackCompliance.setter(Builder::nonCompliantRuleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantRuleCount").build()}).build();
    private static final SdkField<Integer> TOTAL_RULE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalRuleCount").getter(AggregateConformancePackCompliance.getter(AggregateConformancePackCompliance::totalRuleCount)).setter(AggregateConformancePackCompliance.setter(Builder::totalRuleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRuleCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD, COMPLIANT_RULE_COUNT_FIELD, NON_COMPLIANT_RULE_COUNT_FIELD, TOTAL_RULE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregateConformancePackCompliance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String complianceType;
    private final Integer compliantRuleCount;
    private final Integer nonCompliantRuleCount;
    private final Integer totalRuleCount;

    private AggregateConformancePackCompliance(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.compliantRuleCount = builder.compliantRuleCount;
        this.nonCompliantRuleCount = builder.nonCompliantRuleCount;
        this.totalRuleCount = builder.totalRuleCount;
    }

    public final ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(this.complianceType);
    }

    public final String complianceTypeAsString() {
        return this.complianceType;
    }

    public final Integer compliantRuleCount() {
        return this.compliantRuleCount;
    }

    public final Integer nonCompliantRuleCount() {
        return this.nonCompliantRuleCount;
    }

    public final Integer totalRuleCount() {
        return this.totalRuleCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantRuleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantRuleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRuleCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateConformancePackCompliance)) {
            return false;
        }
        AggregateConformancePackCompliance other = (AggregateConformancePackCompliance)obj;
        return Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && Objects.equals(this.compliantRuleCount(), other.compliantRuleCount()) && Objects.equals(this.nonCompliantRuleCount(), other.nonCompliantRuleCount()) && Objects.equals(this.totalRuleCount(), other.totalRuleCount());
    }

    public final String toString() {
        return ToString.builder((String)"AggregateConformancePackCompliance").add("ComplianceType", (Object)this.complianceTypeAsString()).add("CompliantRuleCount", (Object)this.compliantRuleCount()).add("NonCompliantRuleCount", (Object)this.nonCompliantRuleCount()).add("TotalRuleCount", (Object)this.totalRuleCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "CompliantRuleCount": {
                return Optional.ofNullable(clazz.cast(this.compliantRuleCount()));
            }
            case "NonCompliantRuleCount": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantRuleCount()));
            }
            case "TotalRuleCount": {
                return Optional.ofNullable(clazz.cast(this.totalRuleCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ComplianceType", COMPLIANCE_TYPE_FIELD);
        map.put("CompliantRuleCount", COMPLIANT_RULE_COUNT_FIELD);
        map.put("NonCompliantRuleCount", NON_COMPLIANT_RULE_COUNT_FIELD);
        map.put("TotalRuleCount", TOTAL_RULE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregateConformancePackCompliance, T> g) {
        return obj -> g.apply((AggregateConformancePackCompliance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private Integer compliantRuleCount;
        private Integer nonCompliantRuleCount;
        private Integer totalRuleCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateConformancePackCompliance model) {
            this.complianceType(model.complianceType);
            this.compliantRuleCount(model.compliantRuleCount);
            this.nonCompliantRuleCount(model.nonCompliantRuleCount);
            this.totalRuleCount(model.totalRuleCount);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final Integer getCompliantRuleCount() {
            return this.compliantRuleCount;
        }

        public final void setCompliantRuleCount(Integer compliantRuleCount) {
            this.compliantRuleCount = compliantRuleCount;
        }

        @Override
        public final Builder compliantRuleCount(Integer compliantRuleCount) {
            this.compliantRuleCount = compliantRuleCount;
            return this;
        }

        public final Integer getNonCompliantRuleCount() {
            return this.nonCompliantRuleCount;
        }

        public final void setNonCompliantRuleCount(Integer nonCompliantRuleCount) {
            this.nonCompliantRuleCount = nonCompliantRuleCount;
        }

        @Override
        public final Builder nonCompliantRuleCount(Integer nonCompliantRuleCount) {
            this.nonCompliantRuleCount = nonCompliantRuleCount;
            return this;
        }

        public final Integer getTotalRuleCount() {
            return this.totalRuleCount;
        }

        public final void setTotalRuleCount(Integer totalRuleCount) {
            this.totalRuleCount = totalRuleCount;
        }

        @Override
        public final Builder totalRuleCount(Integer totalRuleCount) {
            this.totalRuleCount = totalRuleCount;
            return this;
        }

        public AggregateConformancePackCompliance build() {
            return new AggregateConformancePackCompliance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateConformancePackCompliance> {
        public Builder complianceType(String var1);

        public Builder complianceType(ConformancePackComplianceType var1);

        public Builder compliantRuleCount(Integer var1);

        public Builder nonCompliantRuleCount(Integer var1);

        public Builder totalRuleCount(Integer var1);
    }
}

