/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.RemediationExceptionResourceKey;
import software.amazon.awssdk.services.config.model.RemediationExceptionResourceKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRemediationExceptionsRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutRemediationExceptionsRequest> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigRuleName").getter(PutRemediationExceptionsRequest.getter(PutRemediationExceptionsRequest::configRuleName)).setter(PutRemediationExceptionsRequest.setter(Builder::configRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()}).build();
    private static final SdkField<List<RemediationExceptionResourceKey>> RESOURCE_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceKeys").getter(PutRemediationExceptionsRequest.getter(PutRemediationExceptionsRequest::resourceKeys)).setter(PutRemediationExceptionsRequest.setter(Builder::resourceKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemediationExceptionResourceKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(PutRemediationExceptionsRequest.getter(PutRemediationExceptionsRequest::message)).setter(PutRemediationExceptionsRequest.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationTime").getter(PutRemediationExceptionsRequest.getter(PutRemediationExceptionsRequest::expirationTime)).setter(PutRemediationExceptionsRequest.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD, RESOURCE_KEYS_FIELD, MESSAGE_FIELD, EXPIRATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRemediationExceptionsRequest.memberNameToFieldInitializer();
    private final String configRuleName;
    private final List<RemediationExceptionResourceKey> resourceKeys;
    private final String message;
    private final Instant expirationTime;

    private PutRemediationExceptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
        this.resourceKeys = builder.resourceKeys;
        this.message = builder.message;
        this.expirationTime = builder.expirationTime;
    }

    public final String configRuleName() {
        return this.configRuleName;
    }

    public final boolean hasResourceKeys() {
        return this.resourceKeys != null && !(this.resourceKeys instanceof SdkAutoConstructList);
    }

    public final List<RemediationExceptionResourceKey> resourceKeys() {
        return this.resourceKeys;
    }

    public final String message() {
        return this.message;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceKeys() ? this.resourceKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRemediationExceptionsRequest)) {
            return false;
        }
        PutRemediationExceptionsRequest other = (PutRemediationExceptionsRequest)((Object)obj);
        return Objects.equals(this.configRuleName(), other.configRuleName()) && this.hasResourceKeys() == other.hasResourceKeys() && Objects.equals(this.resourceKeys(), other.resourceKeys()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.expirationTime(), other.expirationTime());
    }

    public final String toString() {
        return ToString.builder((String)"PutRemediationExceptionsRequest").add("ConfigRuleName", (Object)this.configRuleName()).add("ResourceKeys", this.hasResourceKeys() ? this.resourceKeys() : null).add("Message", (Object)this.message()).add("ExpirationTime", (Object)this.expirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.configRuleName()));
            }
            case "ResourceKeys": {
                return Optional.ofNullable(clazz.cast(this.resourceKeys()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigRuleName", CONFIG_RULE_NAME_FIELD);
        map.put("ResourceKeys", RESOURCE_KEYS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ExpirationTime", EXPIRATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRemediationExceptionsRequest, T> g) {
        return obj -> g.apply((PutRemediationExceptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configRuleName;
        private List<RemediationExceptionResourceKey> resourceKeys = DefaultSdkAutoConstructList.getInstance();
        private String message;
        private Instant expirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRemediationExceptionsRequest model) {
            super(model);
            this.configRuleName(model.configRuleName);
            this.resourceKeys(model.resourceKeys);
            this.message(model.message);
            this.expirationTime(model.expirationTime);
        }

        public final String getConfigRuleName() {
            return this.configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final List<RemediationExceptionResourceKey.Builder> getResourceKeys() {
            List<RemediationExceptionResourceKey.Builder> result = RemediationExceptionResourceKeysCopier.copyToBuilder(this.resourceKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceKeys(Collection<RemediationExceptionResourceKey.BuilderImpl> resourceKeys) {
            this.resourceKeys = RemediationExceptionResourceKeysCopier.copyFromBuilder(resourceKeys);
        }

        @Override
        public final Builder resourceKeys(Collection<RemediationExceptionResourceKey> resourceKeys) {
            this.resourceKeys = RemediationExceptionResourceKeysCopier.copy(resourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(RemediationExceptionResourceKey ... resourceKeys) {
            this.resourceKeys(Arrays.asList(resourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(Consumer<RemediationExceptionResourceKey.Builder> ... resourceKeys) {
            this.resourceKeys(Stream.of(resourceKeys).map(c -> (RemediationExceptionResourceKey)((RemediationExceptionResourceKey.Builder)RemediationExceptionResourceKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRemediationExceptionsRequest build() {
            return new PutRemediationExceptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRemediationExceptionsRequest> {
        public Builder configRuleName(String var1);

        public Builder resourceKeys(Collection<RemediationExceptionResourceKey> var1);

        public Builder resourceKeys(RemediationExceptionResourceKey ... var1);

        public Builder resourceKeys(Consumer<RemediationExceptionResourceKey.Builder> ... var1);

        public Builder message(String var1);

        public Builder expirationTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

