/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.RecorderStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationRecorderStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationRecorderStatus> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::arn)).setter(ConfigurationRecorderStatus.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::name)).setter(ConfigurationRecorderStatus.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStartTime").getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastStartTime)).setter(ConfigurationRecorderStatus.setter(Builder::lastStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()}).build();
    private static final SdkField<Instant> LAST_STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStopTime").getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastStopTime)).setter(ConfigurationRecorderStatus.setter(Builder::lastStopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStopTime").build()}).build();
    private static final SdkField<Boolean> RECORDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("recording").getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::recording)).setter(ConfigurationRecorderStatus.setter(Builder::recording)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recording").build()}).build();
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastStatus").getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastStatusAsString)).setter(ConfigurationRecorderStatus.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()}).build();
    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastErrorCode").getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastErrorCode)).setter(ConfigurationRecorderStatus.setter(Builder::lastErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorCode").build()}).build();
    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastErrorMessage").getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastErrorMessage)).setter(ConfigurationRecorderStatus.setter(Builder::lastErrorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorMessage").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_CHANGE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStatusChangeTime").getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::lastStatusChangeTime)).setter(ConfigurationRecorderStatus.setter(Builder::lastStatusChangeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChangeTime").build()}).build();
    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("servicePrincipal").getter(ConfigurationRecorderStatus.getter(ConfigurationRecorderStatus::servicePrincipal)).setter(ConfigurationRecorderStatus.setter(Builder::servicePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servicePrincipal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, LAST_START_TIME_FIELD, LAST_STOP_TIME_FIELD, RECORDING_FIELD, LAST_STATUS_FIELD, LAST_ERROR_CODE_FIELD, LAST_ERROR_MESSAGE_FIELD, LAST_STATUS_CHANGE_TIME_FIELD, SERVICE_PRINCIPAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationRecorderStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final Instant lastStartTime;
    private final Instant lastStopTime;
    private final Boolean recording;
    private final String lastStatus;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Instant lastStatusChangeTime;
    private final String servicePrincipal;

    private ConfigurationRecorderStatus(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.lastStartTime = builder.lastStartTime;
        this.lastStopTime = builder.lastStopTime;
        this.recording = builder.recording;
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
        this.servicePrincipal = builder.servicePrincipal;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final Instant lastStartTime() {
        return this.lastStartTime;
    }

    public final Instant lastStopTime() {
        return this.lastStopTime;
    }

    public final Boolean recording() {
        return this.recording;
    }

    public final RecorderStatus lastStatus() {
        return RecorderStatus.fromValue(this.lastStatus);
    }

    public final String lastStatusAsString() {
        return this.lastStatus;
    }

    public final String lastErrorCode() {
        return this.lastErrorCode;
    }

    public final String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public final Instant lastStatusChangeTime() {
        return this.lastStatusChangeTime;
    }

    public final String servicePrincipal() {
        return this.servicePrincipal;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recording());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusChangeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePrincipal());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderStatus)) {
            return false;
        }
        ConfigurationRecorderStatus other = (ConfigurationRecorderStatus)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.lastStartTime(), other.lastStartTime()) && Objects.equals(this.lastStopTime(), other.lastStopTime()) && Objects.equals(this.recording(), other.recording()) && Objects.equals(this.lastStatusAsString(), other.lastStatusAsString()) && Objects.equals(this.lastErrorCode(), other.lastErrorCode()) && Objects.equals(this.lastErrorMessage(), other.lastErrorMessage()) && Objects.equals(this.lastStatusChangeTime(), other.lastStatusChangeTime()) && Objects.equals(this.servicePrincipal(), other.servicePrincipal());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationRecorderStatus").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("LastStartTime", (Object)this.lastStartTime()).add("LastStopTime", (Object)this.lastStopTime()).add("Recording", (Object)this.recording()).add("LastStatus", (Object)this.lastStatusAsString()).add("LastErrorCode", (Object)this.lastErrorCode()).add("LastErrorMessage", (Object)this.lastErrorMessage()).add("LastStatusChangeTime", (Object)this.lastStatusChangeTime()).add("ServicePrincipal", (Object)this.servicePrincipal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "lastStartTime": {
                return Optional.ofNullable(clazz.cast(this.lastStartTime()));
            }
            case "lastStopTime": {
                return Optional.ofNullable(clazz.cast(this.lastStopTime()));
            }
            case "recording": {
                return Optional.ofNullable(clazz.cast(this.recording()));
            }
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatusAsString()));
            }
            case "lastErrorCode": {
                return Optional.ofNullable(clazz.cast(this.lastErrorCode()));
            }
            case "lastErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.lastErrorMessage()));
            }
            case "lastStatusChangeTime": {
                return Optional.ofNullable(clazz.cast(this.lastStatusChangeTime()));
            }
            case "servicePrincipal": {
                return Optional.ofNullable(clazz.cast(this.servicePrincipal()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("lastStartTime", LAST_START_TIME_FIELD);
        map.put("lastStopTime", LAST_STOP_TIME_FIELD);
        map.put("recording", RECORDING_FIELD);
        map.put("lastStatus", LAST_STATUS_FIELD);
        map.put("lastErrorCode", LAST_ERROR_CODE_FIELD);
        map.put("lastErrorMessage", LAST_ERROR_MESSAGE_FIELD);
        map.put("lastStatusChangeTime", LAST_STATUS_CHANGE_TIME_FIELD);
        map.put("servicePrincipal", SERVICE_PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorderStatus, T> g) {
        return obj -> g.apply((ConfigurationRecorderStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Instant lastStartTime;
        private Instant lastStopTime;
        private Boolean recording;
        private String lastStatus;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Instant lastStatusChangeTime;
        private String servicePrincipal;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderStatus model) {
            this.arn(model.arn);
            this.name(model.name);
            this.lastStartTime(model.lastStartTime);
            this.lastStopTime(model.lastStopTime);
            this.recording(model.recording);
            this.lastStatus(model.lastStatus);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
            this.lastStatusChangeTime(model.lastStatusChangeTime);
            this.servicePrincipal(model.servicePrincipal);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getLastStartTime() {
            return this.lastStartTime;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final Instant getLastStopTime() {
            return this.lastStopTime;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        public final Boolean getRecording() {
            return this.recording;
        }

        public final void setRecording(Boolean recording) {
            this.recording = recording;
        }

        @Override
        public final Builder recording(Boolean recording) {
            this.recording = recording;
            return this;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(RecorderStatus lastStatus) {
            this.lastStatus(lastStatus == null ? null : lastStatus.toString());
            return this;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final Instant getLastStatusChangeTime() {
            return this.lastStatusChangeTime;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final String getServicePrincipal() {
            return this.servicePrincipal;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public ConfigurationRecorderStatus build() {
            return new ConfigurationRecorderStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationRecorderStatus> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder lastStartTime(Instant var1);

        public Builder lastStopTime(Instant var1);

        public Builder recording(Boolean var1);

        public Builder lastStatus(String var1);

        public Builder lastStatus(RecorderStatus var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder lastStatusChangeTime(Instant var1);

        public Builder servicePrincipal(String var1);
    }
}

