/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetentionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetentionConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RetentionConfiguration.getter(RetentionConfiguration::name)).setter(RetentionConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RetentionConfiguration.getter(RetentionConfiguration::retentionPeriodInDays)).setter(RetentionConfiguration.setter(Builder::retentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodInDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RETENTION_PERIOD_IN_DAYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer retentionPeriodInDays;

    private RetentionConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
    }

    public String name() {
        return this.name;
    }

    public Integer retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodInDays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionConfiguration)) {
            return false;
        }
        RetentionConfiguration other = (RetentionConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.retentionPeriodInDays(), other.retentionPeriodInDays());
    }

    public String toString() {
        return ToString.builder((String)"RetentionConfiguration").add("Name", (Object)this.name()).add("RetentionPeriodInDays", (Object)this.retentionPeriodInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodInDays()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetentionConfiguration, T> g) {
        return obj -> g.apply((RetentionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer retentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionConfiguration model) {
            this.name(model.name);
            this.retentionPeriodInDays(model.retentionPeriodInDays);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getRetentionPeriodInDays() {
            return this.retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        public RetentionConfiguration build() {
            return new RetentionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetentionConfiguration> {
        public Builder name(String var1);

        public Builder retentionPeriodInDays(Integer var1);
    }
}

