/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ComplianceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComplianceSummaryByResourceType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComplianceSummaryByResourceType> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComplianceSummaryByResourceType.getter(ComplianceSummaryByResourceType::resourceType)).setter(ComplianceSummaryByResourceType.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<ComplianceSummary> COMPLIANCE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ComplianceSummaryByResourceType.getter(ComplianceSummaryByResourceType::complianceSummary)).setter(ComplianceSummaryByResourceType.setter(Builder::complianceSummary)).constructor(ComplianceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, COMPLIANCE_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final ComplianceSummary complianceSummary;

    private ComplianceSummaryByResourceType(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.complianceSummary = builder.complianceSummary;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public ComplianceSummary complianceSummary() {
        return this.complianceSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummaryByResourceType)) {
            return false;
        }
        ComplianceSummaryByResourceType other = (ComplianceSummaryByResourceType)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.complianceSummary(), other.complianceSummary());
    }

    public String toString() {
        return ToString.builder((String)"ComplianceSummaryByResourceType").add("ResourceType", (Object)this.resourceType()).add("ComplianceSummary", (Object)this.complianceSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ComplianceSummary": {
                return Optional.ofNullable(clazz.cast(this.complianceSummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceSummaryByResourceType, T> g) {
        return obj -> g.apply((ComplianceSummaryByResourceType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private ComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummaryByResourceType model) {
            this.resourceType(model.resourceType);
            this.complianceSummary(model.complianceSummary);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final ComplianceSummary.Builder getComplianceSummary() {
            return this.complianceSummary != null ? this.complianceSummary.toBuilder() : null;
        }

        @Override
        public final Builder complianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final void setComplianceSummary(ComplianceSummary.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        public ComplianceSummaryByResourceType build() {
            return new ComplianceSummaryByResourceType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComplianceSummaryByResourceType> {
        public Builder resourceType(String var1);

        public Builder complianceSummary(ComplianceSummary var1);

        default public Builder complianceSummary(Consumer<ComplianceSummary.Builder> complianceSummary) {
            return this.complianceSummary((ComplianceSummary)((ComplianceSummary.Builder)ComplianceSummary.builder().applyMutation(complianceSummary)).build());
        }
    }
}

