/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigurationItem;
import software.amazon.awssdk.services.config.model.ConfigurationItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceConfigHistoryResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetResourceConfigHistoryResponse> {
    private static final SdkField<List<ConfigurationItem>> CONFIGURATION_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configurationItems").getter(GetResourceConfigHistoryResponse.getter(GetResourceConfigHistoryResponse::configurationItems)).setter(GetResourceConfigHistoryResponse.setter(Builder::configurationItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetResourceConfigHistoryResponse.getter(GetResourceConfigHistoryResponse::nextToken)).setter(GetResourceConfigHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("configurationItems", CONFIGURATION_ITEMS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConfigurationItem> configurationItems;
    private final String nextToken;

    private GetResourceConfigHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.configurationItems = builder.configurationItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurationItems() {
        return this.configurationItems != null && !(this.configurationItems instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationItem> configurationItems() {
        return this.configurationItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationItems() ? this.configurationItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigHistoryResponse)) {
            return false;
        }
        GetResourceConfigHistoryResponse other = (GetResourceConfigHistoryResponse)((Object)obj);
        return this.hasConfigurationItems() == other.hasConfigurationItems() && Objects.equals(this.configurationItems(), other.configurationItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceConfigHistoryResponse").add("ConfigurationItems", this.hasConfigurationItems() ? this.configurationItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurationItems": {
                return Optional.ofNullable(clazz.cast(this.configurationItems()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceConfigHistoryResponse, T> g) {
        return obj -> g.apply((GetResourceConfigHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationItem> configurationItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigHistoryResponse model) {
            super(model);
            this.configurationItems(model.configurationItems);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigurationItem.Builder> getConfigurationItems() {
            List<ConfigurationItem.Builder> result = ConfigurationItemListCopier.copyToBuilder(this.configurationItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationItems(Collection<ConfigurationItem.BuilderImpl> configurationItems) {
            this.configurationItems = ConfigurationItemListCopier.copyFromBuilder(configurationItems);
        }

        @Override
        public final Builder configurationItems(Collection<ConfigurationItem> configurationItems) {
            this.configurationItems = ConfigurationItemListCopier.copy(configurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationItems(ConfigurationItem ... configurationItems) {
            this.configurationItems(Arrays.asList(configurationItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationItems(Consumer<ConfigurationItem.Builder> ... configurationItems) {
            this.configurationItems(Stream.of(configurationItems).map(c -> (ConfigurationItem)((ConfigurationItem.Builder)ConfigurationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetResourceConfigHistoryResponse build() {
            return new GetResourceConfigHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceConfigHistoryResponse> {
        public Builder configurationItems(Collection<ConfigurationItem> var1);

        public Builder configurationItems(ConfigurationItem ... var1);

        public Builder configurationItems(Consumer<ConfigurationItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

