/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatus;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;

public class DescribeConfigurationAggregatorSourcesStatusIterable
implements SdkIterable<DescribeConfigurationAggregatorSourcesStatusResponse> {
    private final ConfigClient client;
    private final DescribeConfigurationAggregatorSourcesStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConfigurationAggregatorSourcesStatusIterable(ConfigClient client, DescribeConfigurationAggregatorSourcesStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeConfigurationAggregatorSourcesStatusResponseFetcher();
    }

    public Iterator<DescribeConfigurationAggregatorSourcesStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AggregatedSourceStatus> aggregatedSourceStatusList() {
        Function<DescribeConfigurationAggregatorSourcesStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.aggregatedSourceStatusList() != null) {
                return response.aggregatedSourceStatusList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeConfigurationAggregatorSourcesStatusResponseFetcher
    implements SyncPageFetcher<DescribeConfigurationAggregatorSourcesStatusResponse> {
        private DescribeConfigurationAggregatorSourcesStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigurationAggregatorSourcesStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeConfigurationAggregatorSourcesStatusResponse nextPage(DescribeConfigurationAggregatorSourcesStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigurationAggregatorSourcesStatusIterable.this.client.describeConfigurationAggregatorSourcesStatus(DescribeConfigurationAggregatorSourcesStatusIterable.this.firstRequest);
            }
            return DescribeConfigurationAggregatorSourcesStatusIterable.this.client.describeConfigurationAggregatorSourcesStatus((DescribeConfigurationAggregatorSourcesStatusRequest)((Object)DescribeConfigurationAggregatorSourcesStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

