/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConfigurationAggregator;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;

public class DescribeConfigurationAggregatorsPublisher
implements SdkPublisher<DescribeConfigurationAggregatorsResponse> {
    private final ConfigAsyncClient client;
    private final DescribeConfigurationAggregatorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConfigurationAggregatorsPublisher(ConfigAsyncClient client, DescribeConfigurationAggregatorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConfigurationAggregatorsPublisher(ConfigAsyncClient client, DescribeConfigurationAggregatorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConfigurationAggregatorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConfigurationAggregatorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationAggregator> configurationAggregators() {
        Function<DescribeConfigurationAggregatorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationAggregators() != null) {
                return response.configurationAggregators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeConfigurationAggregatorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeConfigurationAggregatorsResponseFetcher
    implements AsyncPageFetcher<DescribeConfigurationAggregatorsResponse> {
        private DescribeConfigurationAggregatorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigurationAggregatorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeConfigurationAggregatorsResponse> nextPage(DescribeConfigurationAggregatorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigurationAggregatorsPublisher.this.client.describeConfigurationAggregators(DescribeConfigurationAggregatorsPublisher.this.firstRequest);
            }
            return DescribeConfigurationAggregatorsPublisher.this.client.describeConfigurationAggregators((DescribeConfigurationAggregatorsRequest)((Object)DescribeConfigurationAggregatorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

