/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.config.model.ConfigurationItemStatus;
import software.amazon.awssdk.services.config.model.RecordingFrequency;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.model.SupplementaryConfigurationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BaseConfigurationItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BaseConfigurationItem> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(BaseConfigurationItem.getter(BaseConfigurationItem::version)).setter(BaseConfigurationItem.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(BaseConfigurationItem.getter(BaseConfigurationItem::accountId)).setter(BaseConfigurationItem.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Instant> CONFIGURATION_ITEM_CAPTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("configurationItemCaptureTime").getter(BaseConfigurationItem.getter(BaseConfigurationItem::configurationItemCaptureTime)).setter(BaseConfigurationItem.setter(Builder::configurationItemCaptureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationItemCaptureTime").build()}).build();
    private static final SdkField<String> CONFIGURATION_ITEM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationItemStatus").getter(BaseConfigurationItem.getter(BaseConfigurationItem::configurationItemStatusAsString)).setter(BaseConfigurationItem.setter(Builder::configurationItemStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationItemStatus").build()}).build();
    private static final SdkField<String> CONFIGURATION_STATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationStateId").getter(BaseConfigurationItem.getter(BaseConfigurationItem::configurationStateId)).setter(BaseConfigurationItem.setter(Builder::configurationStateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStateId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(BaseConfigurationItem.getter(BaseConfigurationItem::arn)).setter(BaseConfigurationItem.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(BaseConfigurationItem.getter(BaseConfigurationItem::resourceTypeAsString)).setter(BaseConfigurationItem.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(BaseConfigurationItem.getter(BaseConfigurationItem::resourceId)).setter(BaseConfigurationItem.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(BaseConfigurationItem.getter(BaseConfigurationItem::resourceName)).setter(BaseConfigurationItem.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsRegion").getter(BaseConfigurationItem.getter(BaseConfigurationItem::awsRegion)).setter(BaseConfigurationItem.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(BaseConfigurationItem.getter(BaseConfigurationItem::availabilityZone)).setter(BaseConfigurationItem.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<Instant> RESOURCE_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("resourceCreationTime").getter(BaseConfigurationItem.getter(BaseConfigurationItem::resourceCreationTime)).setter(BaseConfigurationItem.setter(Builder::resourceCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCreationTime").build()}).build();
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuration").getter(BaseConfigurationItem.getter(BaseConfigurationItem::configuration)).setter(BaseConfigurationItem.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Map<String, String>> SUPPLEMENTARY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("supplementaryConfiguration").getter(BaseConfigurationItem.getter(BaseConfigurationItem::supplementaryConfiguration)).setter(BaseConfigurationItem.setter(Builder::supplementaryConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supplementaryConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RECORDING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingFrequency").getter(BaseConfigurationItem.getter(BaseConfigurationItem::recordingFrequencyAsString)).setter(BaseConfigurationItem.setter(Builder::recordingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingFrequency").build()}).build();
    private static final SdkField<Instant> CONFIGURATION_ITEM_DELIVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("configurationItemDeliveryTime").getter(BaseConfigurationItem.getter(BaseConfigurationItem::configurationItemDeliveryTime)).setter(BaseConfigurationItem.setter(Builder::configurationItemDeliveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationItemDeliveryTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, ACCOUNT_ID_FIELD, CONFIGURATION_ITEM_CAPTURE_TIME_FIELD, CONFIGURATION_ITEM_STATUS_FIELD, CONFIGURATION_STATE_ID_FIELD, ARN_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, AWS_REGION_FIELD, AVAILABILITY_ZONE_FIELD, RESOURCE_CREATION_TIME_FIELD, CONFIGURATION_FIELD, SUPPLEMENTARY_CONFIGURATION_FIELD, RECORDING_FREQUENCY_FIELD, CONFIGURATION_ITEM_DELIVERY_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String version;
    private final String accountId;
    private final Instant configurationItemCaptureTime;
    private final String configurationItemStatus;
    private final String configurationStateId;
    private final String arn;
    private final String resourceType;
    private final String resourceId;
    private final String resourceName;
    private final String awsRegion;
    private final String availabilityZone;
    private final Instant resourceCreationTime;
    private final String configuration;
    private final Map<String, String> supplementaryConfiguration;
    private final String recordingFrequency;
    private final Instant configurationItemDeliveryTime;

    private BaseConfigurationItem(BuilderImpl builder) {
        this.version = builder.version;
        this.accountId = builder.accountId;
        this.configurationItemCaptureTime = builder.configurationItemCaptureTime;
        this.configurationItemStatus = builder.configurationItemStatus;
        this.configurationStateId = builder.configurationStateId;
        this.arn = builder.arn;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.awsRegion = builder.awsRegion;
        this.availabilityZone = builder.availabilityZone;
        this.resourceCreationTime = builder.resourceCreationTime;
        this.configuration = builder.configuration;
        this.supplementaryConfiguration = builder.supplementaryConfiguration;
        this.recordingFrequency = builder.recordingFrequency;
        this.configurationItemDeliveryTime = builder.configurationItemDeliveryTime;
    }

    public final String version() {
        return this.version;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Instant configurationItemCaptureTime() {
        return this.configurationItemCaptureTime;
    }

    public final ConfigurationItemStatus configurationItemStatus() {
        return ConfigurationItemStatus.fromValue(this.configurationItemStatus);
    }

    public final String configurationItemStatusAsString() {
        return this.configurationItemStatus;
    }

    public final String configurationStateId() {
        return this.configurationStateId;
    }

    public final String arn() {
        return this.arn;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Instant resourceCreationTime() {
        return this.resourceCreationTime;
    }

    public final String configuration() {
        return this.configuration;
    }

    public final boolean hasSupplementaryConfiguration() {
        return this.supplementaryConfiguration != null && !(this.supplementaryConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> supplementaryConfiguration() {
        return this.supplementaryConfiguration;
    }

    public final RecordingFrequency recordingFrequency() {
        return RecordingFrequency.fromValue(this.recordingFrequency);
    }

    public final String recordingFrequencyAsString() {
        return this.recordingFrequency;
    }

    public final Instant configurationItemDeliveryTime() {
        return this.configurationItemDeliveryTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemCaptureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupplementaryConfiguration() ? this.supplementaryConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItemDeliveryTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseConfigurationItem)) {
            return false;
        }
        BaseConfigurationItem other = (BaseConfigurationItem)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.configurationItemCaptureTime(), other.configurationItemCaptureTime()) && Objects.equals(this.configurationItemStatusAsString(), other.configurationItemStatusAsString()) && Objects.equals(this.configurationStateId(), other.configurationStateId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.resourceCreationTime(), other.resourceCreationTime()) && Objects.equals(this.configuration(), other.configuration()) && this.hasSupplementaryConfiguration() == other.hasSupplementaryConfiguration() && Objects.equals(this.supplementaryConfiguration(), other.supplementaryConfiguration()) && Objects.equals(this.recordingFrequencyAsString(), other.recordingFrequencyAsString()) && Objects.equals(this.configurationItemDeliveryTime(), other.configurationItemDeliveryTime());
    }

    public final String toString() {
        return ToString.builder((String)"BaseConfigurationItem").add("Version", (Object)this.version()).add("AccountId", (Object)this.accountId()).add("ConfigurationItemCaptureTime", (Object)this.configurationItemCaptureTime()).add("ConfigurationItemStatus", (Object)this.configurationItemStatusAsString()).add("ConfigurationStateId", (Object)this.configurationStateId()).add("Arn", (Object)this.arn()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("ResourceName", (Object)this.resourceName()).add("AwsRegion", (Object)this.awsRegion()).add("AvailabilityZone", (Object)this.availabilityZone()).add("ResourceCreationTime", (Object)this.resourceCreationTime()).add("Configuration", (Object)this.configuration()).add("SupplementaryConfiguration", this.hasSupplementaryConfiguration() ? this.supplementaryConfiguration() : null).add("RecordingFrequency", (Object)this.recordingFrequencyAsString()).add("ConfigurationItemDeliveryTime", (Object)this.configurationItemDeliveryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "configurationItemCaptureTime": {
                return Optional.ofNullable(clazz.cast(this.configurationItemCaptureTime()));
            }
            case "configurationItemStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationItemStatusAsString()));
            }
            case "configurationStateId": {
                return Optional.ofNullable(clazz.cast(this.configurationStateId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "resourceCreationTime": {
                return Optional.ofNullable(clazz.cast(this.resourceCreationTime()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "supplementaryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.supplementaryConfiguration()));
            }
            case "recordingFrequency": {
                return Optional.ofNullable(clazz.cast(this.recordingFrequencyAsString()));
            }
            case "configurationItemDeliveryTime": {
                return Optional.ofNullable(clazz.cast(this.configurationItemDeliveryTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BaseConfigurationItem, T> g) {
        return obj -> g.apply((BaseConfigurationItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private String accountId;
        private Instant configurationItemCaptureTime;
        private String configurationItemStatus;
        private String configurationStateId;
        private String arn;
        private String resourceType;
        private String resourceId;
        private String resourceName;
        private String awsRegion;
        private String availabilityZone;
        private Instant resourceCreationTime;
        private String configuration;
        private Map<String, String> supplementaryConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String recordingFrequency;
        private Instant configurationItemDeliveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BaseConfigurationItem model) {
            this.version(model.version);
            this.accountId(model.accountId);
            this.configurationItemCaptureTime(model.configurationItemCaptureTime);
            this.configurationItemStatus(model.configurationItemStatus);
            this.configurationStateId(model.configurationStateId);
            this.arn(model.arn);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceName(model.resourceName);
            this.awsRegion(model.awsRegion);
            this.availabilityZone(model.availabilityZone);
            this.resourceCreationTime(model.resourceCreationTime);
            this.configuration(model.configuration);
            this.supplementaryConfiguration(model.supplementaryConfiguration);
            this.recordingFrequency(model.recordingFrequency);
            this.configurationItemDeliveryTime(model.configurationItemDeliveryTime);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getConfigurationItemCaptureTime() {
            return this.configurationItemCaptureTime;
        }

        public final void setConfigurationItemCaptureTime(Instant configurationItemCaptureTime) {
            this.configurationItemCaptureTime = configurationItemCaptureTime;
        }

        @Override
        public final Builder configurationItemCaptureTime(Instant configurationItemCaptureTime) {
            this.configurationItemCaptureTime = configurationItemCaptureTime;
            return this;
        }

        public final String getConfigurationItemStatus() {
            return this.configurationItemStatus;
        }

        public final void setConfigurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
        }

        @Override
        public final Builder configurationItemStatus(String configurationItemStatus) {
            this.configurationItemStatus = configurationItemStatus;
            return this;
        }

        @Override
        public final Builder configurationItemStatus(ConfigurationItemStatus configurationItemStatus) {
            this.configurationItemStatus(configurationItemStatus == null ? null : configurationItemStatus.toString());
            return this;
        }

        public final String getConfigurationStateId() {
            return this.configurationStateId;
        }

        public final void setConfigurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
        }

        @Override
        public final Builder configurationStateId(String configurationStateId) {
            this.configurationStateId = configurationStateId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Instant getResourceCreationTime() {
            return this.resourceCreationTime;
        }

        public final void setResourceCreationTime(Instant resourceCreationTime) {
            this.resourceCreationTime = resourceCreationTime;
        }

        @Override
        public final Builder resourceCreationTime(Instant resourceCreationTime) {
            this.resourceCreationTime = resourceCreationTime;
            return this;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Map<String, String> getSupplementaryConfiguration() {
            if (this.supplementaryConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.supplementaryConfiguration;
        }

        public final void setSupplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
        }

        @Override
        public final Builder supplementaryConfiguration(Map<String, String> supplementaryConfiguration) {
            this.supplementaryConfiguration = SupplementaryConfigurationCopier.copy(supplementaryConfiguration);
            return this;
        }

        public final String getRecordingFrequency() {
            return this.recordingFrequency;
        }

        public final void setRecordingFrequency(String recordingFrequency) {
            this.recordingFrequency = recordingFrequency;
        }

        @Override
        public final Builder recordingFrequency(String recordingFrequency) {
            this.recordingFrequency = recordingFrequency;
            return this;
        }

        @Override
        public final Builder recordingFrequency(RecordingFrequency recordingFrequency) {
            this.recordingFrequency(recordingFrequency == null ? null : recordingFrequency.toString());
            return this;
        }

        public final Instant getConfigurationItemDeliveryTime() {
            return this.configurationItemDeliveryTime;
        }

        public final void setConfigurationItemDeliveryTime(Instant configurationItemDeliveryTime) {
            this.configurationItemDeliveryTime = configurationItemDeliveryTime;
        }

        @Override
        public final Builder configurationItemDeliveryTime(Instant configurationItemDeliveryTime) {
            this.configurationItemDeliveryTime = configurationItemDeliveryTime;
            return this;
        }

        public BaseConfigurationItem build() {
            return new BaseConfigurationItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BaseConfigurationItem> {
        public Builder version(String var1);

        public Builder accountId(String var1);

        public Builder configurationItemCaptureTime(Instant var1);

        public Builder configurationItemStatus(String var1);

        public Builder configurationItemStatus(ConfigurationItemStatus var1);

        public Builder configurationStateId(String var1);

        public Builder arn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder resourceName(String var1);

        public Builder awsRegion(String var1);

        public Builder availabilityZone(String var1);

        public Builder resourceCreationTime(Instant var1);

        public Builder configuration(String var1);

        public Builder supplementaryConfiguration(Map<String, String> var1);

        public Builder recordingFrequency(String var1);

        public Builder recordingFrequency(RecordingFrequency var1);

        public Builder configurationItemDeliveryTime(Instant var1);
    }
}

