/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.AggregateResourceIdentifier;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;

public class ListAggregateDiscoveredResourcesIterable
implements SdkIterable<ListAggregateDiscoveredResourcesResponse> {
    private final ConfigClient client;
    private final ListAggregateDiscoveredResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAggregateDiscoveredResourcesIterable(ConfigClient client, ListAggregateDiscoveredResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAggregateDiscoveredResourcesResponseFetcher();
    }

    public Iterator<ListAggregateDiscoveredResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AggregateResourceIdentifier> resourceIdentifiers() {
        Function<ListAggregateDiscoveredResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceIdentifiers() != null) {
                return response.resourceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAggregateDiscoveredResourcesResponseFetcher
    implements SyncPageFetcher<ListAggregateDiscoveredResourcesResponse> {
        private ListAggregateDiscoveredResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAggregateDiscoveredResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAggregateDiscoveredResourcesResponse nextPage(ListAggregateDiscoveredResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAggregateDiscoveredResourcesIterable.this.client.listAggregateDiscoveredResources(ListAggregateDiscoveredResourcesIterable.this.firstRequest);
            }
            return ListAggregateDiscoveredResourcesIterable.this.client.listAggregateDiscoveredResources((ListAggregateDiscoveredResourcesRequest)((Object)ListAggregateDiscoveredResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

