/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComplianceType {
    COMPLIANT("COMPLIANT"),
    NON_COMPLIANT("NON_COMPLIANT"),
    NOT_APPLICABLE("NOT_APPLICABLE"),
    INSUFFICIENT_DATA("INSUFFICIENT_DATA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComplianceType> VALUE_MAP;
    private final String value;

    private ComplianceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComplianceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComplianceType> knownValues() {
        EnumSet<ComplianceType> knownValues = EnumSet.allOf(ComplianceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComplianceType.class, ComplianceType::toString);
    }
}

