/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse;
import software.amazon.awssdk.services.config.model.RemediationExecutionStatus;

public class DescribeRemediationExecutionStatusIterable
implements SdkIterable<DescribeRemediationExecutionStatusResponse> {
    private final ConfigClient client;
    private final DescribeRemediationExecutionStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRemediationExecutionStatusIterable(ConfigClient client, DescribeRemediationExecutionStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeRemediationExecutionStatusResponseFetcher();
    }

    public Iterator<DescribeRemediationExecutionStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RemediationExecutionStatus> remediationExecutionStatuses() {
        Function<DescribeRemediationExecutionStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.remediationExecutionStatuses() != null) {
                return response.remediationExecutionStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRemediationExecutionStatusResponseFetcher
    implements SyncPageFetcher<DescribeRemediationExecutionStatusResponse> {
        private DescribeRemediationExecutionStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRemediationExecutionStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRemediationExecutionStatusResponse nextPage(DescribeRemediationExecutionStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeRemediationExecutionStatusIterable.this.client.describeRemediationExecutionStatus(DescribeRemediationExecutionStatusIterable.this.firstRequest);
            }
            return DescribeRemediationExecutionStatusIterable.this.client.describeRemediationExecutionStatus((DescribeRemediationExecutionStatusRequest)((Object)DescribeRemediationExecutionStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

