/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.model.EvaluationResult;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;

public class GetComplianceDetailsByConfigRulePublisher
implements SdkPublisher<GetComplianceDetailsByConfigRuleResponse> {
    private final ConfigAsyncClient client;
    private final GetComplianceDetailsByConfigRuleRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetComplianceDetailsByConfigRulePublisher(ConfigAsyncClient client, GetComplianceDetailsByConfigRuleRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetComplianceDetailsByConfigRulePublisher(ConfigAsyncClient client, GetComplianceDetailsByConfigRuleRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetComplianceDetailsByConfigRuleResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetComplianceDetailsByConfigRuleResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EvaluationResult> evaluationResults() {
        Function<GetComplianceDetailsByConfigRuleResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationResults() != null) {
                return response.evaluationResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetComplianceDetailsByConfigRuleResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetComplianceDetailsByConfigRuleResponseFetcher
    implements AsyncPageFetcher<GetComplianceDetailsByConfigRuleResponse> {
        private GetComplianceDetailsByConfigRuleResponseFetcher() {
        }

        public boolean hasNextPage(GetComplianceDetailsByConfigRuleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetComplianceDetailsByConfigRuleResponse> nextPage(GetComplianceDetailsByConfigRuleResponse previousPage) {
            if (previousPage == null) {
                return GetComplianceDetailsByConfigRulePublisher.this.client.getComplianceDetailsByConfigRule(GetComplianceDetailsByConfigRulePublisher.this.firstRequest);
            }
            return GetComplianceDetailsByConfigRulePublisher.this.client.getComplianceDetailsByConfigRule((GetComplianceDetailsByConfigRuleRequest)((Object)GetComplianceDetailsByConfigRulePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

