/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigRuleState {
    ACTIVE("ACTIVE"),
    DELETING("DELETING"),
    DELETING_RESULTS("DELETING_RESULTS"),
    EVALUATING("EVALUATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigRuleState> VALUE_MAP;
    private final String value;

    private ConfigRuleState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigRuleState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigRuleState> knownValues() {
        EnumSet<ConfigRuleState> knownValues = EnumSet.allOf(ConfigRuleState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigRuleState.class, ConfigRuleState::toString);
    }
}

