/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.model.AggregationAuthorization;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;

public class DescribeAggregationAuthorizationsPublisher
implements SdkPublisher<DescribeAggregationAuthorizationsResponse> {
    private final ConfigAsyncClient client;
    private final DescribeAggregationAuthorizationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAggregationAuthorizationsPublisher(ConfigAsyncClient client, DescribeAggregationAuthorizationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAggregationAuthorizationsPublisher(ConfigAsyncClient client, DescribeAggregationAuthorizationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAggregationAuthorizationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAggregationAuthorizationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AggregationAuthorization> aggregationAuthorizations() {
        Function<DescribeAggregationAuthorizationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aggregationAuthorizations() != null) {
                return response.aggregationAuthorizations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAggregationAuthorizationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAggregationAuthorizationsResponseFetcher
    implements AsyncPageFetcher<DescribeAggregationAuthorizationsResponse> {
        private DescribeAggregationAuthorizationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAggregationAuthorizationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAggregationAuthorizationsResponse> nextPage(DescribeAggregationAuthorizationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAggregationAuthorizationsPublisher.this.client.describeAggregationAuthorizations(DescribeAggregationAuthorizationsPublisher.this.firstRequest);
            }
            return DescribeAggregationAuthorizationsPublisher.this.client.describeAggregationAuthorizations((DescribeAggregationAuthorizationsRequest)((Object)DescribeAggregationAuthorizationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

