/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.ConformancePackDetail;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse;

public class DescribeConformancePacksIterable
implements SdkIterable<DescribeConformancePacksResponse> {
    private final ConfigClient client;
    private final DescribeConformancePacksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConformancePacksIterable(ConfigClient client, DescribeConformancePacksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeConformancePacksResponseFetcher();
    }

    public Iterator<DescribeConformancePacksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConformancePackDetail> conformancePackDetails() {
        Function<DescribeConformancePacksResponse, Iterator> getIterator = response -> {
            if (response != null && response.conformancePackDetails() != null) {
                return response.conformancePackDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeConformancePacksResponseFetcher
    implements SyncPageFetcher<DescribeConformancePacksResponse> {
        private DescribeConformancePacksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConformancePacksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeConformancePacksResponse nextPage(DescribeConformancePacksResponse previousPage) {
            if (previousPage == null) {
                return DescribeConformancePacksIterable.this.client.describeConformancePacks(DescribeConformancePacksIterable.this.firstRequest);
            }
            return DescribeConformancePacksIterable.this.client.describeConformancePacks((DescribeConformancePacksRequest)((Object)DescribeConformancePacksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

