/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationRecorderStatusRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationRecorderStatusRequest> {
    private static final SdkField<List<String>> CONFIGURATION_RECORDER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationRecorderNames").getter(DescribeConfigurationRecorderStatusRequest.getter(DescribeConfigurationRecorderStatusRequest::configurationRecorderNames)).setter(DescribeConfigurationRecorderStatusRequest.setter(Builder::configurationRecorderNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecorderNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_RECORDER_NAMES_FIELD));
    private final List<String> configurationRecorderNames;

    private DescribeConfigurationRecorderStatusRequest(BuilderImpl builder) {
        super(builder);
        this.configurationRecorderNames = builder.configurationRecorderNames;
    }

    public final boolean hasConfigurationRecorderNames() {
        return this.configurationRecorderNames != null && !(this.configurationRecorderNames instanceof SdkAutoConstructList);
    }

    public final List<String> configurationRecorderNames() {
        return this.configurationRecorderNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationRecorderNames() ? this.configurationRecorderNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecorderStatusRequest)) {
            return false;
        }
        DescribeConfigurationRecorderStatusRequest other = (DescribeConfigurationRecorderStatusRequest)((Object)obj);
        return this.hasConfigurationRecorderNames() == other.hasConfigurationRecorderNames() && Objects.equals(this.configurationRecorderNames(), other.configurationRecorderNames());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationRecorderStatusRequest").add("ConfigurationRecorderNames", this.hasConfigurationRecorderNames() ? this.configurationRecorderNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationRecorderNames": {
                return Optional.ofNullable(clazz.cast(this.configurationRecorderNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRecorderStatusRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationRecorderStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private List<String> configurationRecorderNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecorderStatusRequest model) {
            super(model);
            this.configurationRecorderNames(model.configurationRecorderNames);
        }

        public final Collection<String> getConfigurationRecorderNames() {
            if (this.configurationRecorderNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configurationRecorderNames;
        }

        public final void setConfigurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
        }

        @Override
        @Transient
        public final Builder configurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder configurationRecorderNames(String ... configurationRecorderNames) {
            this.configurationRecorderNames(Arrays.asList(configurationRecorderNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationRecorderStatusRequest build() {
            return new DescribeConfigurationRecorderStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationRecorderStatusRequest> {
        public Builder configurationRecorderNames(Collection<String> var1);

        public Builder configurationRecorderNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

