/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.StoredQueryMetadata;
import software.amazon.awssdk.services.config.model.StoredQueryMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStoredQueriesResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, ListStoredQueriesResponse> {
    private static final SdkField<List<StoredQueryMetadata>> STORED_QUERY_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StoredQueryMetadata").getter(ListStoredQueriesResponse.getter(ListStoredQueriesResponse::storedQueryMetadata)).setter(ListStoredQueriesResponse.setter(Builder::storedQueryMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoredQueryMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StoredQueryMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStoredQueriesResponse.getter(ListStoredQueriesResponse::nextToken)).setter(ListStoredQueriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORED_QUERY_METADATA_FIELD, NEXT_TOKEN_FIELD));
    private final List<StoredQueryMetadata> storedQueryMetadata;
    private final String nextToken;

    private ListStoredQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.storedQueryMetadata = builder.storedQueryMetadata;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStoredQueryMetadata() {
        return this.storedQueryMetadata != null && !(this.storedQueryMetadata instanceof SdkAutoConstructList);
    }

    public final List<StoredQueryMetadata> storedQueryMetadata() {
        return this.storedQueryMetadata;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStoredQueryMetadata() ? this.storedQueryMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStoredQueriesResponse)) {
            return false;
        }
        ListStoredQueriesResponse other = (ListStoredQueriesResponse)((Object)obj);
        return this.hasStoredQueryMetadata() == other.hasStoredQueryMetadata() && Objects.equals(this.storedQueryMetadata(), other.storedQueryMetadata()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStoredQueriesResponse").add("StoredQueryMetadata", this.hasStoredQueryMetadata() ? this.storedQueryMetadata() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StoredQueryMetadata": {
                return Optional.ofNullable(clazz.cast(this.storedQueryMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStoredQueriesResponse, T> g) {
        return obj -> g.apply((ListStoredQueriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<StoredQueryMetadata> storedQueryMetadata = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStoredQueriesResponse model) {
            super(model);
            this.storedQueryMetadata(model.storedQueryMetadata);
            this.nextToken(model.nextToken);
        }

        public final List<StoredQueryMetadata.Builder> getStoredQueryMetadata() {
            List<StoredQueryMetadata.Builder> result = StoredQueryMetadataListCopier.copyToBuilder(this.storedQueryMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStoredQueryMetadata(Collection<StoredQueryMetadata.BuilderImpl> storedQueryMetadata) {
            this.storedQueryMetadata = StoredQueryMetadataListCopier.copyFromBuilder(storedQueryMetadata);
        }

        @Override
        @Transient
        public final Builder storedQueryMetadata(Collection<StoredQueryMetadata> storedQueryMetadata) {
            this.storedQueryMetadata = StoredQueryMetadataListCopier.copy(storedQueryMetadata);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder storedQueryMetadata(StoredQueryMetadata ... storedQueryMetadata) {
            this.storedQueryMetadata(Arrays.asList(storedQueryMetadata));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder storedQueryMetadata(Consumer<StoredQueryMetadata.Builder> ... storedQueryMetadata) {
            this.storedQueryMetadata(Stream.of(storedQueryMetadata).map(c -> (StoredQueryMetadata)((StoredQueryMetadata.Builder)StoredQueryMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStoredQueriesResponse build() {
            return new ListStoredQueriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStoredQueriesResponse> {
        public Builder storedQueryMetadata(Collection<StoredQueryMetadata> var1);

        public Builder storedQueryMetadata(StoredQueryMetadata ... var1);

        public Builder storedQueryMetadata(Consumer<StoredQueryMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

