/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.StoredQuery;
import software.amazon.awssdk.services.config.model.Tag;
import software.amazon.awssdk.services.config.model.TagsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutStoredQueryRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutStoredQueryRequest> {
    private static final SdkField<StoredQuery> STORED_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoredQuery").getter(PutStoredQueryRequest.getter(PutStoredQueryRequest::storedQuery)).setter(PutStoredQueryRequest.setter(Builder::storedQuery)).constructor(StoredQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoredQuery").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PutStoredQueryRequest.getter(PutStoredQueryRequest::tags)).setter(PutStoredQueryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORED_QUERY_FIELD, TAGS_FIELD));
    private final StoredQuery storedQuery;
    private final List<Tag> tags;

    private PutStoredQueryRequest(BuilderImpl builder) {
        super(builder);
        this.storedQuery = builder.storedQuery;
        this.tags = builder.tags;
    }

    public final StoredQuery storedQuery() {
        return this.storedQuery;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storedQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStoredQueryRequest)) {
            return false;
        }
        PutStoredQueryRequest other = (PutStoredQueryRequest)((Object)obj);
        return Objects.equals(this.storedQuery(), other.storedQuery()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PutStoredQueryRequest").add("StoredQuery", (Object)this.storedQuery()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StoredQuery": {
                return Optional.ofNullable(clazz.cast(this.storedQuery()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutStoredQueryRequest, T> g) {
        return obj -> g.apply((PutStoredQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private StoredQuery storedQuery;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutStoredQueryRequest model) {
            super(model);
            this.storedQuery(model.storedQuery);
            this.tags(model.tags);
        }

        public final StoredQuery.Builder getStoredQuery() {
            return this.storedQuery != null ? this.storedQuery.toBuilder() : null;
        }

        @Override
        public final Builder storedQuery(StoredQuery storedQuery) {
            this.storedQuery = storedQuery;
            return this;
        }

        public final void setStoredQuery(StoredQuery.BuilderImpl storedQuery) {
            this.storedQuery = storedQuery != null ? storedQuery.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutStoredQueryRequest build() {
            return new PutStoredQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutStoredQueryRequest> {
        public Builder storedQuery(StoredQuery var1);

        default public Builder storedQuery(Consumer<StoredQuery.Builder> storedQuery) {
            return this.storedQuery((StoredQuery)((StoredQuery.Builder)StoredQuery.builder().applyMutation(storedQuery)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

