/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackDetailedStatus;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackDetailedStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOrganizationConformancePackDetailedStatusResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetOrganizationConformancePackDetailedStatusResponse> {
    private static final SdkField<List<OrganizationConformancePackDetailedStatus>> ORGANIZATION_CONFORMANCE_PACK_DETAILED_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConformancePackDetailedStatuses").getter(GetOrganizationConformancePackDetailedStatusResponse.getter(GetOrganizationConformancePackDetailedStatusResponse::organizationConformancePackDetailedStatuses)).setter(GetOrganizationConformancePackDetailedStatusResponse.setter(Builder::organizationConformancePackDetailedStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackDetailedStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationConformancePackDetailedStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetOrganizationConformancePackDetailedStatusResponse.getter(GetOrganizationConformancePackDetailedStatusResponse::nextToken)).setter(GetOrganizationConformancePackDetailedStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFORMANCE_PACK_DETAILED_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private final List<OrganizationConformancePackDetailedStatus> organizationConformancePackDetailedStatuses;
    private final String nextToken;

    private GetOrganizationConformancePackDetailedStatusResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackDetailedStatuses = builder.organizationConformancePackDetailedStatuses;
        this.nextToken = builder.nextToken;
    }

    public boolean hasOrganizationConformancePackDetailedStatuses() {
        return this.organizationConformancePackDetailedStatuses != null && !(this.organizationConformancePackDetailedStatuses instanceof SdkAutoConstructList);
    }

    public List<OrganizationConformancePackDetailedStatus> organizationConformancePackDetailedStatuses() {
        return this.organizationConformancePackDetailedStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConformancePackDetailedStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationConformancePackDetailedStatusResponse)) {
            return false;
        }
        GetOrganizationConformancePackDetailedStatusResponse other = (GetOrganizationConformancePackDetailedStatusResponse)((Object)obj);
        return Objects.equals(this.organizationConformancePackDetailedStatuses(), other.organizationConformancePackDetailedStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetOrganizationConformancePackDetailedStatusResponse").add("OrganizationConformancePackDetailedStatuses", this.organizationConformancePackDetailedStatuses()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConformancePackDetailedStatuses": {
                return Optional.ofNullable(clazz.cast(this.organizationConformancePackDetailedStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationConformancePackDetailedStatusResponse, T> g) {
        return obj -> g.apply((GetOrganizationConformancePackDetailedStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<OrganizationConformancePackDetailedStatus> organizationConformancePackDetailedStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationConformancePackDetailedStatusResponse model) {
            super(model);
            this.organizationConformancePackDetailedStatuses(model.organizationConformancePackDetailedStatuses);
            this.nextToken(model.nextToken);
        }

        public final Collection<OrganizationConformancePackDetailedStatus.Builder> getOrganizationConformancePackDetailedStatuses() {
            return this.organizationConformancePackDetailedStatuses != null ? (Collection)this.organizationConformancePackDetailedStatuses.stream().map(OrganizationConformancePackDetailedStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationConformancePackDetailedStatuses(Collection<OrganizationConformancePackDetailedStatus> organizationConformancePackDetailedStatuses) {
            this.organizationConformancePackDetailedStatuses = OrganizationConformancePackDetailedStatusesCopier.copy(organizationConformancePackDetailedStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackDetailedStatuses(OrganizationConformancePackDetailedStatus ... organizationConformancePackDetailedStatuses) {
            this.organizationConformancePackDetailedStatuses(Arrays.asList(organizationConformancePackDetailedStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackDetailedStatuses(Consumer<OrganizationConformancePackDetailedStatus.Builder> ... organizationConformancePackDetailedStatuses) {
            this.organizationConformancePackDetailedStatuses(Stream.of(organizationConformancePackDetailedStatuses).map(c -> (OrganizationConformancePackDetailedStatus)((OrganizationConformancePackDetailedStatus.Builder)OrganizationConformancePackDetailedStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationConformancePackDetailedStatuses(Collection<OrganizationConformancePackDetailedStatus.BuilderImpl> organizationConformancePackDetailedStatuses) {
            this.organizationConformancePackDetailedStatuses = OrganizationConformancePackDetailedStatusesCopier.copyFromBuilder(organizationConformancePackDetailedStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetOrganizationConformancePackDetailedStatusResponse build() {
            return new GetOrganizationConformancePackDetailedStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOrganizationConformancePackDetailedStatusResponse> {
        public Builder organizationConformancePackDetailedStatuses(Collection<OrganizationConformancePackDetailedStatus> var1);

        public Builder organizationConformancePackDetailedStatuses(OrganizationConformancePackDetailedStatus ... var1);

        public Builder organizationConformancePackDetailedStatuses(Consumer<OrganizationConformancePackDetailedStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

