/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AccountAggregationSource;
import software.amazon.awssdk.services.config.model.AccountAggregationSourceListCopier;
import software.amazon.awssdk.services.config.model.OrganizationAggregationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationAggregator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationAggregator> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationAggregatorName").getter(ConfigurationAggregator.getter(ConfigurationAggregator::configurationAggregatorName)).setter(ConfigurationAggregator.setter(Builder::configurationAggregatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName").build()}).build();
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationAggregatorArn").getter(ConfigurationAggregator.getter(ConfigurationAggregator::configurationAggregatorArn)).setter(ConfigurationAggregator.setter(Builder::configurationAggregatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorArn").build()}).build();
    private static final SdkField<List<AccountAggregationSource>> ACCOUNT_AGGREGATION_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountAggregationSources").getter(ConfigurationAggregator.getter(ConfigurationAggregator::accountAggregationSources)).setter(ConfigurationAggregator.setter(Builder::accountAggregationSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAggregationSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountAggregationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OrganizationAggregationSource> ORGANIZATION_AGGREGATION_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationAggregationSource").getter(ConfigurationAggregator.getter(ConfigurationAggregator::organizationAggregationSource)).setter(ConfigurationAggregator.setter(Builder::organizationAggregationSource)).constructor(OrganizationAggregationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationAggregationSource").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ConfigurationAggregator.getter(ConfigurationAggregator::creationTime)).setter(ConfigurationAggregator.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(ConfigurationAggregator.getter(ConfigurationAggregator::lastUpdatedTime)).setter(ConfigurationAggregator.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(ConfigurationAggregator.getter(ConfigurationAggregator::createdBy)).setter(ConfigurationAggregator.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_AGGREGATOR_NAME_FIELD, CONFIGURATION_AGGREGATOR_ARN_FIELD, ACCOUNT_AGGREGATION_SOURCES_FIELD, ORGANIZATION_AGGREGATION_SOURCE_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configurationAggregatorName;
    private final String configurationAggregatorArn;
    private final List<AccountAggregationSource> accountAggregationSources;
    private final OrganizationAggregationSource organizationAggregationSource;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final String createdBy;

    private ConfigurationAggregator(BuilderImpl builder) {
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.configurationAggregatorArn = builder.configurationAggregatorArn;
        this.accountAggregationSources = builder.accountAggregationSources;
        this.organizationAggregationSource = builder.organizationAggregationSource;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdBy = builder.createdBy;
    }

    public String configurationAggregatorName() {
        return this.configurationAggregatorName;
    }

    public String configurationAggregatorArn() {
        return this.configurationAggregatorArn;
    }

    public boolean hasAccountAggregationSources() {
        return this.accountAggregationSources != null && !(this.accountAggregationSources instanceof SdkAutoConstructList);
    }

    public List<AccountAggregationSource> accountAggregationSources() {
        return this.accountAggregationSources;
    }

    public OrganizationAggregationSource organizationAggregationSource() {
        return this.organizationAggregationSource;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountAggregationSources() ? this.accountAggregationSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationAggregationSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationAggregator)) {
            return false;
        }
        ConfigurationAggregator other = (ConfigurationAggregator)obj;
        return Objects.equals(this.configurationAggregatorName(), other.configurationAggregatorName()) && Objects.equals(this.configurationAggregatorArn(), other.configurationAggregatorArn()) && this.hasAccountAggregationSources() == other.hasAccountAggregationSources() && Objects.equals(this.accountAggregationSources(), other.accountAggregationSources()) && Objects.equals(this.organizationAggregationSource(), other.organizationAggregationSource()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public String toString() {
        return ToString.builder((String)"ConfigurationAggregator").add("ConfigurationAggregatorName", (Object)this.configurationAggregatorName()).add("ConfigurationAggregatorArn", (Object)this.configurationAggregatorArn()).add("AccountAggregationSources", this.hasAccountAggregationSources() ? this.accountAggregationSources() : null).add("OrganizationAggregationSource", (Object)this.organizationAggregationSource()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedBy", (Object)this.createdBy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregatorName": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorName()));
            }
            case "ConfigurationAggregatorArn": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorArn()));
            }
            case "AccountAggregationSources": {
                return Optional.ofNullable(clazz.cast(this.accountAggregationSources()));
            }
            case "OrganizationAggregationSource": {
                return Optional.ofNullable(clazz.cast(this.organizationAggregationSource()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationAggregator, T> g) {
        return obj -> g.apply((ConfigurationAggregator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationAggregatorName;
        private String configurationAggregatorArn;
        private List<AccountAggregationSource> accountAggregationSources = DefaultSdkAutoConstructList.getInstance();
        private OrganizationAggregationSource organizationAggregationSource;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationAggregator model) {
            this.configurationAggregatorName(model.configurationAggregatorName);
            this.configurationAggregatorArn(model.configurationAggregatorArn);
            this.accountAggregationSources(model.accountAggregationSources);
            this.organizationAggregationSource(model.organizationAggregationSource);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdBy(model.createdBy);
        }

        public final String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final String getConfigurationAggregatorArn() {
            return this.configurationAggregatorArn;
        }

        @Override
        public final Builder configurationAggregatorArn(String configurationAggregatorArn) {
            this.configurationAggregatorArn = configurationAggregatorArn;
            return this;
        }

        public final void setConfigurationAggregatorArn(String configurationAggregatorArn) {
            this.configurationAggregatorArn = configurationAggregatorArn;
        }

        public final Collection<AccountAggregationSource.Builder> getAccountAggregationSources() {
            if (this.accountAggregationSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountAggregationSources != null ? (Collection)this.accountAggregationSources.stream().map(AccountAggregationSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountAggregationSources(Collection<AccountAggregationSource> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copy(accountAggregationSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAggregationSources(AccountAggregationSource ... accountAggregationSources) {
            this.accountAggregationSources(Arrays.asList(accountAggregationSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder> ... accountAggregationSources) {
            this.accountAggregationSources(Stream.of(accountAggregationSources).map(c -> (AccountAggregationSource)((AccountAggregationSource.Builder)AccountAggregationSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountAggregationSources(Collection<AccountAggregationSource.BuilderImpl> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copyFromBuilder(accountAggregationSources);
        }

        public final OrganizationAggregationSource.Builder getOrganizationAggregationSource() {
            return this.organizationAggregationSource != null ? this.organizationAggregationSource.toBuilder() : null;
        }

        @Override
        public final Builder organizationAggregationSource(OrganizationAggregationSource organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource;
            return this;
        }

        public final void setOrganizationAggregationSource(OrganizationAggregationSource.BuilderImpl organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource != null ? organizationAggregationSource.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public ConfigurationAggregator build() {
            return new ConfigurationAggregator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationAggregator> {
        public Builder configurationAggregatorName(String var1);

        public Builder configurationAggregatorArn(String var1);

        public Builder accountAggregationSources(Collection<AccountAggregationSource> var1);

        public Builder accountAggregationSources(AccountAggregationSource ... var1);

        public Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder> ... var1);

        public Builder organizationAggregationSource(OrganizationAggregationSource var1);

        default public Builder organizationAggregationSource(Consumer<OrganizationAggregationSource.Builder> organizationAggregationSource) {
            return this.organizationAggregationSource((OrganizationAggregationSource)((OrganizationAggregationSource.Builder)OrganizationAggregationSource.builder().applyMutation(organizationAggregationSource)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder createdBy(String var1);
    }
}

