/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigurationAggregator;
import software.amazon.awssdk.services.config.model.ConfigurationAggregatorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationAggregatorsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationAggregatorsResponse> {
    private static final SdkField<List<ConfigurationAggregator>> CONFIGURATION_AGGREGATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationAggregators").getter(DescribeConfigurationAggregatorsResponse.getter(DescribeConfigurationAggregatorsResponse::configurationAggregators)).setter(DescribeConfigurationAggregatorsResponse.setter(Builder::configurationAggregators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationAggregator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeConfigurationAggregatorsResponse.getter(DescribeConfigurationAggregatorsResponse::nextToken)).setter(DescribeConfigurationAggregatorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_AGGREGATORS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ConfigurationAggregator> configurationAggregators;
    private final String nextToken;

    private DescribeConfigurationAggregatorsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationAggregators = builder.configurationAggregators;
        this.nextToken = builder.nextToken;
    }

    public boolean hasConfigurationAggregators() {
        return this.configurationAggregators != null && !(this.configurationAggregators instanceof SdkAutoConstructList);
    }

    public List<ConfigurationAggregator> configurationAggregators() {
        return this.configurationAggregators;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationAggregators() ? this.configurationAggregators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationAggregatorsResponse)) {
            return false;
        }
        DescribeConfigurationAggregatorsResponse other = (DescribeConfigurationAggregatorsResponse)((Object)obj);
        return this.hasConfigurationAggregators() == other.hasConfigurationAggregators() && Objects.equals(this.configurationAggregators(), other.configurationAggregators()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationAggregatorsResponse").add("ConfigurationAggregators", this.hasConfigurationAggregators() ? this.configurationAggregators() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregators": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregators()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationAggregatorsResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationAggregatorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationAggregator> configurationAggregators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationAggregatorsResponse model) {
            super(model);
            this.configurationAggregators(model.configurationAggregators);
            this.nextToken(model.nextToken);
        }

        public final Collection<ConfigurationAggregator.Builder> getConfigurationAggregators() {
            if (this.configurationAggregators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configurationAggregators != null ? (Collection)this.configurationAggregators.stream().map(ConfigurationAggregator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationAggregators(Collection<ConfigurationAggregator> configurationAggregators) {
            this.configurationAggregators = ConfigurationAggregatorListCopier.copy(configurationAggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationAggregators(ConfigurationAggregator ... configurationAggregators) {
            this.configurationAggregators(Arrays.asList(configurationAggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationAggregators(Consumer<ConfigurationAggregator.Builder> ... configurationAggregators) {
            this.configurationAggregators(Stream.of(configurationAggregators).map(c -> (ConfigurationAggregator)((ConfigurationAggregator.Builder)ConfigurationAggregator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationAggregators(Collection<ConfigurationAggregator.BuilderImpl> configurationAggregators) {
            this.configurationAggregators = ConfigurationAggregatorListCopier.copyFromBuilder(configurationAggregators);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConfigurationAggregatorsResponse build() {
            return new DescribeConfigurationAggregatorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationAggregatorsResponse> {
        public Builder configurationAggregators(Collection<ConfigurationAggregator> var1);

        public Builder configurationAggregators(ConfigurationAggregator ... var1);

        public Builder configurationAggregators(Consumer<ConfigurationAggregator.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

