/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConformancePackInputParameter;
import software.amazon.awssdk.services.config.model.ConformancePackInputParametersCopier;
import software.amazon.awssdk.services.config.model.ExcludedAccountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutOrganizationConformancePackRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutOrganizationConformancePackRequest> {
    private static final SdkField<String> ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationConformancePackName").getter(PutOrganizationConformancePackRequest.getter(PutOrganizationConformancePackRequest::organizationConformancePackName)).setter(PutOrganizationConformancePackRequest.setter(Builder::organizationConformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackName").build()}).build();
    private static final SdkField<String> TEMPLATE_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateS3Uri").getter(PutOrganizationConformancePackRequest.getter(PutOrganizationConformancePackRequest::templateS3Uri)).setter(PutOrganizationConformancePackRequest.setter(Builder::templateS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateS3Uri").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(PutOrganizationConformancePackRequest.getter(PutOrganizationConformancePackRequest::templateBody)).setter(PutOrganizationConformancePackRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<String> DELIVERY_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryS3Bucket").getter(PutOrganizationConformancePackRequest.getter(PutOrganizationConformancePackRequest::deliveryS3Bucket)).setter(PutOrganizationConformancePackRequest.setter(Builder::deliveryS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Bucket").build()}).build();
    private static final SdkField<String> DELIVERY_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryS3KeyPrefix").getter(PutOrganizationConformancePackRequest.getter(PutOrganizationConformancePackRequest::deliveryS3KeyPrefix)).setter(PutOrganizationConformancePackRequest.setter(Builder::deliveryS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3KeyPrefix").build()}).build();
    private static final SdkField<List<ConformancePackInputParameter>> CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConformancePackInputParameters").getter(PutOrganizationConformancePackRequest.getter(PutOrganizationConformancePackRequest::conformancePackInputParameters)).setter(PutOrganizationConformancePackRequest.setter(Builder::conformancePackInputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackInputParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConformancePackInputParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedAccounts").getter(PutOrganizationConformancePackRequest.getter(PutOrganizationConformancePackRequest::excludedAccounts)).setter(PutOrganizationConformancePackRequest.setter(Builder::excludedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD, TEMPLATE_S3_URI_FIELD, TEMPLATE_BODY_FIELD, DELIVERY_S3_BUCKET_FIELD, DELIVERY_S3_KEY_PREFIX_FIELD, CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD, EXCLUDED_ACCOUNTS_FIELD));
    private final String organizationConformancePackName;
    private final String templateS3Uri;
    private final String templateBody;
    private final String deliveryS3Bucket;
    private final String deliveryS3KeyPrefix;
    private final List<ConformancePackInputParameter> conformancePackInputParameters;
    private final List<String> excludedAccounts;

    private PutOrganizationConformancePackRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackName = builder.organizationConformancePackName;
        this.templateS3Uri = builder.templateS3Uri;
        this.templateBody = builder.templateBody;
        this.deliveryS3Bucket = builder.deliveryS3Bucket;
        this.deliveryS3KeyPrefix = builder.deliveryS3KeyPrefix;
        this.conformancePackInputParameters = builder.conformancePackInputParameters;
        this.excludedAccounts = builder.excludedAccounts;
    }

    public String organizationConformancePackName() {
        return this.organizationConformancePackName;
    }

    public String templateS3Uri() {
        return this.templateS3Uri;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String deliveryS3Bucket() {
        return this.deliveryS3Bucket;
    }

    public String deliveryS3KeyPrefix() {
        return this.deliveryS3KeyPrefix;
    }

    public boolean hasConformancePackInputParameters() {
        return this.conformancePackInputParameters != null && !(this.conformancePackInputParameters instanceof SdkAutoConstructList);
    }

    public List<ConformancePackInputParameter> conformancePackInputParameters() {
        return this.conformancePackInputParameters;
    }

    public boolean hasExcludedAccounts() {
        return this.excludedAccounts != null && !(this.excludedAccounts instanceof SdkAutoConstructList);
    }

    public List<String> excludedAccounts() {
        return this.excludedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackInputParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludedAccounts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutOrganizationConformancePackRequest)) {
            return false;
        }
        PutOrganizationConformancePackRequest other = (PutOrganizationConformancePackRequest)((Object)obj);
        return Objects.equals(this.organizationConformancePackName(), other.organizationConformancePackName()) && Objects.equals(this.templateS3Uri(), other.templateS3Uri()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.deliveryS3Bucket(), other.deliveryS3Bucket()) && Objects.equals(this.deliveryS3KeyPrefix(), other.deliveryS3KeyPrefix()) && Objects.equals(this.conformancePackInputParameters(), other.conformancePackInputParameters()) && Objects.equals(this.excludedAccounts(), other.excludedAccounts());
    }

    public String toString() {
        return ToString.builder((String)"PutOrganizationConformancePackRequest").add("OrganizationConformancePackName", (Object)this.organizationConformancePackName()).add("TemplateS3Uri", (Object)this.templateS3Uri()).add("TemplateBody", (Object)this.templateBody()).add("DeliveryS3Bucket", (Object)this.deliveryS3Bucket()).add("DeliveryS3KeyPrefix", (Object)this.deliveryS3KeyPrefix()).add("ConformancePackInputParameters", this.conformancePackInputParameters()).add("ExcludedAccounts", this.excludedAccounts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.organizationConformancePackName()));
            }
            case "TemplateS3Uri": {
                return Optional.ofNullable(clazz.cast(this.templateS3Uri()));
            }
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "DeliveryS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.deliveryS3Bucket()));
            }
            case "DeliveryS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.deliveryS3KeyPrefix()));
            }
            case "ConformancePackInputParameters": {
                return Optional.ofNullable(clazz.cast(this.conformancePackInputParameters()));
            }
            case "ExcludedAccounts": {
                return Optional.ofNullable(clazz.cast(this.excludedAccounts()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutOrganizationConformancePackRequest, T> g) {
        return obj -> g.apply((PutOrganizationConformancePackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String organizationConformancePackName;
        private String templateS3Uri;
        private String templateBody;
        private String deliveryS3Bucket;
        private String deliveryS3KeyPrefix;
        private List<ConformancePackInputParameter> conformancePackInputParameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutOrganizationConformancePackRequest model) {
            super(model);
            this.organizationConformancePackName(model.organizationConformancePackName);
            this.templateS3Uri(model.templateS3Uri);
            this.templateBody(model.templateBody);
            this.deliveryS3Bucket(model.deliveryS3Bucket);
            this.deliveryS3KeyPrefix(model.deliveryS3KeyPrefix);
            this.conformancePackInputParameters(model.conformancePackInputParameters);
            this.excludedAccounts(model.excludedAccounts);
        }

        public final String getOrganizationConformancePackName() {
            return this.organizationConformancePackName;
        }

        @Override
        public final Builder organizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
            return this;
        }

        public final void setOrganizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
        }

        public final String getTemplateS3Uri() {
            return this.templateS3Uri;
        }

        @Override
        public final Builder templateS3Uri(String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
            return this;
        }

        public final void setTemplateS3Uri(String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getDeliveryS3Bucket() {
            return this.deliveryS3Bucket;
        }

        @Override
        public final Builder deliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
            return this;
        }

        public final void setDeliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
        }

        public final String getDeliveryS3KeyPrefix() {
            return this.deliveryS3KeyPrefix;
        }

        @Override
        public final Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
            return this;
        }

        public final void setDeliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
        }

        public final Collection<ConformancePackInputParameter.Builder> getConformancePackInputParameters() {
            return this.conformancePackInputParameters != null ? (Collection)this.conformancePackInputParameters.stream().map(ConformancePackInputParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copy(conformancePackInputParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(ConformancePackInputParameter ... conformancePackInputParameters) {
            this.conformancePackInputParameters(Arrays.asList(conformancePackInputParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder> ... conformancePackInputParameters) {
            this.conformancePackInputParameters(Stream.of(conformancePackInputParameters).map(c -> (ConformancePackInputParameter)((ConformancePackInputParameter.Builder)ConformancePackInputParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackInputParameters(Collection<ConformancePackInputParameter.BuilderImpl> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copyFromBuilder(conformancePackInputParameters);
        }

        public final Collection<String> getExcludedAccounts() {
            return this.excludedAccounts;
        }

        @Override
        public final Builder excludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAccounts(String ... excludedAccounts) {
            this.excludedAccounts(Arrays.asList(excludedAccounts));
            return this;
        }

        public final void setExcludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutOrganizationConformancePackRequest build() {
            return new PutOrganizationConformancePackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutOrganizationConformancePackRequest> {
        public Builder organizationConformancePackName(String var1);

        public Builder templateS3Uri(String var1);

        public Builder templateBody(String var1);

        public Builder deliveryS3Bucket(String var1);

        public Builder deliveryS3KeyPrefix(String var1);

        public Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> var1);

        public Builder conformancePackInputParameters(ConformancePackInputParameter ... var1);

        public Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder> ... var1);

        public Builder excludedAccounts(Collection<String> var1);

        public Builder excludedAccounts(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

