/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConformancePackInputParameter;
import software.amazon.awssdk.services.config.model.ConformancePackInputParametersCopier;
import software.amazon.awssdk.services.config.model.ExcludedAccountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationConformancePack
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationConformancePack> {
    private static final SdkField<String> ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationConformancePackName").getter(OrganizationConformancePack.getter(OrganizationConformancePack::organizationConformancePackName)).setter(OrganizationConformancePack.setter(Builder::organizationConformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackName").build()}).build();
    private static final SdkField<String> ORGANIZATION_CONFORMANCE_PACK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationConformancePackArn").getter(OrganizationConformancePack.getter(OrganizationConformancePack::organizationConformancePackArn)).setter(OrganizationConformancePack.setter(Builder::organizationConformancePackArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackArn").build()}).build();
    private static final SdkField<String> DELIVERY_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryS3Bucket").getter(OrganizationConformancePack.getter(OrganizationConformancePack::deliveryS3Bucket)).setter(OrganizationConformancePack.setter(Builder::deliveryS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Bucket").build()}).build();
    private static final SdkField<String> DELIVERY_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryS3KeyPrefix").getter(OrganizationConformancePack.getter(OrganizationConformancePack::deliveryS3KeyPrefix)).setter(OrganizationConformancePack.setter(Builder::deliveryS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3KeyPrefix").build()}).build();
    private static final SdkField<List<ConformancePackInputParameter>> CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConformancePackInputParameters").getter(OrganizationConformancePack.getter(OrganizationConformancePack::conformancePackInputParameters)).setter(OrganizationConformancePack.setter(Builder::conformancePackInputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackInputParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConformancePackInputParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedAccounts").getter(OrganizationConformancePack.getter(OrganizationConformancePack::excludedAccounts)).setter(OrganizationConformancePack.setter(Builder::excludedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(OrganizationConformancePack.getter(OrganizationConformancePack::lastUpdateTime)).setter(OrganizationConformancePack.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFORMANCE_PACK_NAME_FIELD, ORGANIZATION_CONFORMANCE_PACK_ARN_FIELD, DELIVERY_S3_BUCKET_FIELD, DELIVERY_S3_KEY_PREFIX_FIELD, CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD, EXCLUDED_ACCOUNTS_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String organizationConformancePackName;
    private final String organizationConformancePackArn;
    private final String deliveryS3Bucket;
    private final String deliveryS3KeyPrefix;
    private final List<ConformancePackInputParameter> conformancePackInputParameters;
    private final List<String> excludedAccounts;
    private final Instant lastUpdateTime;

    private OrganizationConformancePack(BuilderImpl builder) {
        this.organizationConformancePackName = builder.organizationConformancePackName;
        this.organizationConformancePackArn = builder.organizationConformancePackArn;
        this.deliveryS3Bucket = builder.deliveryS3Bucket;
        this.deliveryS3KeyPrefix = builder.deliveryS3KeyPrefix;
        this.conformancePackInputParameters = builder.conformancePackInputParameters;
        this.excludedAccounts = builder.excludedAccounts;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public String organizationConformancePackName() {
        return this.organizationConformancePackName;
    }

    public String organizationConformancePackArn() {
        return this.organizationConformancePackArn;
    }

    public String deliveryS3Bucket() {
        return this.deliveryS3Bucket;
    }

    public String deliveryS3KeyPrefix() {
        return this.deliveryS3KeyPrefix;
    }

    public boolean hasConformancePackInputParameters() {
        return this.conformancePackInputParameters != null && !(this.conformancePackInputParameters instanceof SdkAutoConstructList);
    }

    public List<ConformancePackInputParameter> conformancePackInputParameters() {
        return this.conformancePackInputParameters;
    }

    public boolean hasExcludedAccounts() {
        return this.excludedAccounts != null && !(this.excludedAccounts instanceof SdkAutoConstructList);
    }

    public List<String> excludedAccounts() {
        return this.excludedAccounts;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConformancePackArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConformancePackInputParameters() ? this.conformancePackInputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedAccounts() ? this.excludedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationConformancePack)) {
            return false;
        }
        OrganizationConformancePack other = (OrganizationConformancePack)obj;
        return Objects.equals(this.organizationConformancePackName(), other.organizationConformancePackName()) && Objects.equals(this.organizationConformancePackArn(), other.organizationConformancePackArn()) && Objects.equals(this.deliveryS3Bucket(), other.deliveryS3Bucket()) && Objects.equals(this.deliveryS3KeyPrefix(), other.deliveryS3KeyPrefix()) && this.hasConformancePackInputParameters() == other.hasConformancePackInputParameters() && Objects.equals(this.conformancePackInputParameters(), other.conformancePackInputParameters()) && this.hasExcludedAccounts() == other.hasExcludedAccounts() && Objects.equals(this.excludedAccounts(), other.excludedAccounts()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public String toString() {
        return ToString.builder((String)"OrganizationConformancePack").add("OrganizationConformancePackName", (Object)this.organizationConformancePackName()).add("OrganizationConformancePackArn", (Object)this.organizationConformancePackArn()).add("DeliveryS3Bucket", (Object)this.deliveryS3Bucket()).add("DeliveryS3KeyPrefix", (Object)this.deliveryS3KeyPrefix()).add("ConformancePackInputParameters", this.hasConformancePackInputParameters() ? this.conformancePackInputParameters() : null).add("ExcludedAccounts", this.hasExcludedAccounts() ? this.excludedAccounts() : null).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.organizationConformancePackName()));
            }
            case "OrganizationConformancePackArn": {
                return Optional.ofNullable(clazz.cast(this.organizationConformancePackArn()));
            }
            case "DeliveryS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.deliveryS3Bucket()));
            }
            case "DeliveryS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.deliveryS3KeyPrefix()));
            }
            case "ConformancePackInputParameters": {
                return Optional.ofNullable(clazz.cast(this.conformancePackInputParameters()));
            }
            case "ExcludedAccounts": {
                return Optional.ofNullable(clazz.cast(this.excludedAccounts()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationConformancePack, T> g) {
        return obj -> g.apply((OrganizationConformancePack)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationConformancePackName;
        private String organizationConformancePackArn;
        private String deliveryS3Bucket;
        private String deliveryS3KeyPrefix;
        private List<ConformancePackInputParameter> conformancePackInputParameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedAccounts = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationConformancePack model) {
            this.organizationConformancePackName(model.organizationConformancePackName);
            this.organizationConformancePackArn(model.organizationConformancePackArn);
            this.deliveryS3Bucket(model.deliveryS3Bucket);
            this.deliveryS3KeyPrefix(model.deliveryS3KeyPrefix);
            this.conformancePackInputParameters(model.conformancePackInputParameters);
            this.excludedAccounts(model.excludedAccounts);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getOrganizationConformancePackName() {
            return this.organizationConformancePackName;
        }

        @Override
        public final Builder organizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
            return this;
        }

        public final void setOrganizationConformancePackName(String organizationConformancePackName) {
            this.organizationConformancePackName = organizationConformancePackName;
        }

        public final String getOrganizationConformancePackArn() {
            return this.organizationConformancePackArn;
        }

        @Override
        public final Builder organizationConformancePackArn(String organizationConformancePackArn) {
            this.organizationConformancePackArn = organizationConformancePackArn;
            return this;
        }

        public final void setOrganizationConformancePackArn(String organizationConformancePackArn) {
            this.organizationConformancePackArn = organizationConformancePackArn;
        }

        public final String getDeliveryS3Bucket() {
            return this.deliveryS3Bucket;
        }

        @Override
        public final Builder deliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
            return this;
        }

        public final void setDeliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
        }

        public final String getDeliveryS3KeyPrefix() {
            return this.deliveryS3KeyPrefix;
        }

        @Override
        public final Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
            return this;
        }

        public final void setDeliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
        }

        public final Collection<ConformancePackInputParameter.Builder> getConformancePackInputParameters() {
            if (this.conformancePackInputParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.conformancePackInputParameters != null ? (Collection)this.conformancePackInputParameters.stream().map(ConformancePackInputParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copy(conformancePackInputParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(ConformancePackInputParameter ... conformancePackInputParameters) {
            this.conformancePackInputParameters(Arrays.asList(conformancePackInputParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder> ... conformancePackInputParameters) {
            this.conformancePackInputParameters(Stream.of(conformancePackInputParameters).map(c -> (ConformancePackInputParameter)((ConformancePackInputParameter.Builder)ConformancePackInputParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackInputParameters(Collection<ConformancePackInputParameter.BuilderImpl> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copyFromBuilder(conformancePackInputParameters);
        }

        public final Collection<String> getExcludedAccounts() {
            if (this.excludedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedAccounts;
        }

        @Override
        public final Builder excludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAccounts(String ... excludedAccounts) {
            this.excludedAccounts(Arrays.asList(excludedAccounts));
            return this;
        }

        public final void setExcludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public OrganizationConformancePack build() {
            return new OrganizationConformancePack(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationConformancePack> {
        public Builder organizationConformancePackName(String var1);

        public Builder organizationConformancePackArn(String var1);

        public Builder deliveryS3Bucket(String var1);

        public Builder deliveryS3KeyPrefix(String var1);

        public Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> var1);

        public Builder conformancePackInputParameters(ConformancePackInputParameter ... var1);

        public Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder> ... var1);

        public Builder excludedAccounts(Collection<String> var1);

        public Builder excludedAccounts(String ... var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

