/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConformancePackInputParameter;
import software.amazon.awssdk.services.config.model.ConformancePackInputParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutConformancePackRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutConformancePackRequest> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConformancePackName").getter(PutConformancePackRequest.getter(PutConformancePackRequest::conformancePackName)).setter(PutConformancePackRequest.setter(Builder::conformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build()}).build();
    private static final SdkField<String> TEMPLATE_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateS3Uri").getter(PutConformancePackRequest.getter(PutConformancePackRequest::templateS3Uri)).setter(PutConformancePackRequest.setter(Builder::templateS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateS3Uri").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(PutConformancePackRequest.getter(PutConformancePackRequest::templateBody)).setter(PutConformancePackRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<String> DELIVERY_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryS3Bucket").getter(PutConformancePackRequest.getter(PutConformancePackRequest::deliveryS3Bucket)).setter(PutConformancePackRequest.setter(Builder::deliveryS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3Bucket").build()}).build();
    private static final SdkField<String> DELIVERY_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryS3KeyPrefix").getter(PutConformancePackRequest.getter(PutConformancePackRequest::deliveryS3KeyPrefix)).setter(PutConformancePackRequest.setter(Builder::deliveryS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryS3KeyPrefix").build()}).build();
    private static final SdkField<List<ConformancePackInputParameter>> CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConformancePackInputParameters").getter(PutConformancePackRequest.getter(PutConformancePackRequest::conformancePackInputParameters)).setter(PutConformancePackRequest.setter(Builder::conformancePackInputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackInputParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConformancePackInputParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD, TEMPLATE_S3_URI_FIELD, TEMPLATE_BODY_FIELD, DELIVERY_S3_BUCKET_FIELD, DELIVERY_S3_KEY_PREFIX_FIELD, CONFORMANCE_PACK_INPUT_PARAMETERS_FIELD));
    private final String conformancePackName;
    private final String templateS3Uri;
    private final String templateBody;
    private final String deliveryS3Bucket;
    private final String deliveryS3KeyPrefix;
    private final List<ConformancePackInputParameter> conformancePackInputParameters;

    private PutConformancePackRequest(BuilderImpl builder) {
        super(builder);
        this.conformancePackName = builder.conformancePackName;
        this.templateS3Uri = builder.templateS3Uri;
        this.templateBody = builder.templateBody;
        this.deliveryS3Bucket = builder.deliveryS3Bucket;
        this.deliveryS3KeyPrefix = builder.deliveryS3KeyPrefix;
        this.conformancePackInputParameters = builder.conformancePackInputParameters;
    }

    public String conformancePackName() {
        return this.conformancePackName;
    }

    public String templateS3Uri() {
        return this.templateS3Uri;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String deliveryS3Bucket() {
        return this.deliveryS3Bucket;
    }

    public String deliveryS3KeyPrefix() {
        return this.deliveryS3KeyPrefix;
    }

    public boolean hasConformancePackInputParameters() {
        return this.conformancePackInputParameters != null && !(this.conformancePackInputParameters instanceof SdkAutoConstructList);
    }

    public List<ConformancePackInputParameter> conformancePackInputParameters() {
        return this.conformancePackInputParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConformancePackInputParameters() ? this.conformancePackInputParameters() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConformancePackRequest)) {
            return false;
        }
        PutConformancePackRequest other = (PutConformancePackRequest)((Object)obj);
        return Objects.equals(this.conformancePackName(), other.conformancePackName()) && Objects.equals(this.templateS3Uri(), other.templateS3Uri()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.deliveryS3Bucket(), other.deliveryS3Bucket()) && Objects.equals(this.deliveryS3KeyPrefix(), other.deliveryS3KeyPrefix()) && this.hasConformancePackInputParameters() == other.hasConformancePackInputParameters() && Objects.equals(this.conformancePackInputParameters(), other.conformancePackInputParameters());
    }

    public String toString() {
        return ToString.builder((String)"PutConformancePackRequest").add("ConformancePackName", (Object)this.conformancePackName()).add("TemplateS3Uri", (Object)this.templateS3Uri()).add("TemplateBody", (Object)this.templateBody()).add("DeliveryS3Bucket", (Object)this.deliveryS3Bucket()).add("DeliveryS3KeyPrefix", (Object)this.deliveryS3KeyPrefix()).add("ConformancePackInputParameters", this.hasConformancePackInputParameters() ? this.conformancePackInputParameters() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.conformancePackName()));
            }
            case "TemplateS3Uri": {
                return Optional.ofNullable(clazz.cast(this.templateS3Uri()));
            }
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "DeliveryS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.deliveryS3Bucket()));
            }
            case "DeliveryS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.deliveryS3KeyPrefix()));
            }
            case "ConformancePackInputParameters": {
                return Optional.ofNullable(clazz.cast(this.conformancePackInputParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConformancePackRequest, T> g) {
        return obj -> g.apply((PutConformancePackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String conformancePackName;
        private String templateS3Uri;
        private String templateBody;
        private String deliveryS3Bucket;
        private String deliveryS3KeyPrefix;
        private List<ConformancePackInputParameter> conformancePackInputParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutConformancePackRequest model) {
            super(model);
            this.conformancePackName(model.conformancePackName);
            this.templateS3Uri(model.templateS3Uri);
            this.templateBody(model.templateBody);
            this.deliveryS3Bucket(model.deliveryS3Bucket);
            this.deliveryS3KeyPrefix(model.deliveryS3KeyPrefix);
            this.conformancePackInputParameters(model.conformancePackInputParameters);
        }

        public final String getConformancePackName() {
            return this.conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        public final String getTemplateS3Uri() {
            return this.templateS3Uri;
        }

        @Override
        public final Builder templateS3Uri(String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
            return this;
        }

        public final void setTemplateS3Uri(String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getDeliveryS3Bucket() {
            return this.deliveryS3Bucket;
        }

        @Override
        public final Builder deliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
            return this;
        }

        public final void setDeliveryS3Bucket(String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
        }

        public final String getDeliveryS3KeyPrefix() {
            return this.deliveryS3KeyPrefix;
        }

        @Override
        public final Builder deliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
            return this;
        }

        public final void setDeliveryS3KeyPrefix(String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
        }

        public final Collection<ConformancePackInputParameter.Builder> getConformancePackInputParameters() {
            if (this.conformancePackInputParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.conformancePackInputParameters != null ? (Collection)this.conformancePackInputParameters.stream().map(ConformancePackInputParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copy(conformancePackInputParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(ConformancePackInputParameter ... conformancePackInputParameters) {
            this.conformancePackInputParameters(Arrays.asList(conformancePackInputParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder> ... conformancePackInputParameters) {
            this.conformancePackInputParameters(Stream.of(conformancePackInputParameters).map(c -> (ConformancePackInputParameter)((ConformancePackInputParameter.Builder)ConformancePackInputParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConformancePackInputParameters(Collection<ConformancePackInputParameter.BuilderImpl> conformancePackInputParameters) {
            this.conformancePackInputParameters = ConformancePackInputParametersCopier.copyFromBuilder(conformancePackInputParameters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConformancePackRequest build() {
            return new PutConformancePackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutConformancePackRequest> {
        public Builder conformancePackName(String var1);

        public Builder templateS3Uri(String var1);

        public Builder templateBody(String var1);

        public Builder deliveryS3Bucket(String var1);

        public Builder deliveryS3KeyPrefix(String var1);

        public Builder conformancePackInputParameters(Collection<ConformancePackInputParameter> var1);

        public Builder conformancePackInputParameters(ConformancePackInputParameter ... var1);

        public Builder conformancePackInputParameters(Consumer<ConformancePackInputParameter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

