/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.FieldInfo;
import software.amazon.awssdk.services.config.model.FieldInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryInfo> {
    private static final SdkField<List<FieldInfo>> SELECT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectFields").getter(QueryInfo.getter(QueryInfo::selectFields)).setter(QueryInfo.setter(Builder::selectFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECT_FIELDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<FieldInfo> selectFields;

    private QueryInfo(BuilderImpl builder) {
        this.selectFields = builder.selectFields;
    }

    public boolean hasSelectFields() {
        return this.selectFields != null && !(this.selectFields instanceof SdkAutoConstructList);
    }

    public List<FieldInfo> selectFields() {
        return this.selectFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.selectFields());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryInfo)) {
            return false;
        }
        QueryInfo other = (QueryInfo)obj;
        return Objects.equals(this.selectFields(), other.selectFields());
    }

    public String toString() {
        return ToString.builder((String)"QueryInfo").add("SelectFields", this.selectFields()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectFields": {
                return Optional.ofNullable(clazz.cast(this.selectFields()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryInfo, T> g) {
        return obj -> g.apply((QueryInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldInfo> selectFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryInfo model) {
            this.selectFields(model.selectFields);
        }

        public final Collection<FieldInfo.Builder> getSelectFields() {
            return this.selectFields != null ? (Collection)this.selectFields.stream().map(FieldInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder selectFields(Collection<FieldInfo> selectFields) {
            this.selectFields = FieldInfoListCopier.copy(selectFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectFields(FieldInfo ... selectFields) {
            this.selectFields(Arrays.asList(selectFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectFields(Consumer<FieldInfo.Builder> ... selectFields) {
            this.selectFields(Stream.of(selectFields).map(c -> (FieldInfo)((FieldInfo.Builder)FieldInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSelectFields(Collection<FieldInfo.BuilderImpl> selectFields) {
            this.selectFields = FieldInfoListCopier.copyFromBuilder(selectFields);
        }

        public QueryInfo build() {
            return new QueryInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryInfo> {
        public Builder selectFields(Collection<FieldInfo> var1);

        public Builder selectFields(FieldInfo ... var1);

        public Builder selectFields(Consumer<FieldInfo.Builder> ... var1);
    }
}

