/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackStatus;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConformancePackStatusesResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationConformancePackStatusesResponse> {
    private static final SdkField<List<OrganizationConformancePackStatus>> ORGANIZATION_CONFORMANCE_PACK_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConformancePackStatuses").getter(DescribeOrganizationConformancePackStatusesResponse.getter(DescribeOrganizationConformancePackStatusesResponse::organizationConformancePackStatuses)).setter(DescribeOrganizationConformancePackStatusesResponse.setter(Builder::organizationConformancePackStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationConformancePackStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOrganizationConformancePackStatusesResponse.getter(DescribeOrganizationConformancePackStatusesResponse::nextToken)).setter(DescribeOrganizationConformancePackStatusesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFORMANCE_PACK_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private final List<OrganizationConformancePackStatus> organizationConformancePackStatuses;
    private final String nextToken;

    private DescribeOrganizationConformancePackStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackStatuses = builder.organizationConformancePackStatuses;
        this.nextToken = builder.nextToken;
    }

    public boolean hasOrganizationConformancePackStatuses() {
        return this.organizationConformancePackStatuses != null && !(this.organizationConformancePackStatuses instanceof SdkAutoConstructList);
    }

    public List<OrganizationConformancePackStatus> organizationConformancePackStatuses() {
        return this.organizationConformancePackStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConformancePackStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConformancePackStatusesResponse)) {
            return false;
        }
        DescribeOrganizationConformancePackStatusesResponse other = (DescribeOrganizationConformancePackStatusesResponse)((Object)obj);
        return Objects.equals(this.organizationConformancePackStatuses(), other.organizationConformancePackStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOrganizationConformancePackStatusesResponse").add("OrganizationConformancePackStatuses", this.organizationConformancePackStatuses()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConformancePackStatuses": {
                return Optional.ofNullable(clazz.cast(this.organizationConformancePackStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConformancePackStatusesResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConformancePackStatusesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<OrganizationConformancePackStatus> organizationConformancePackStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConformancePackStatusesResponse model) {
            super(model);
            this.organizationConformancePackStatuses(model.organizationConformancePackStatuses);
            this.nextToken(model.nextToken);
        }

        public final Collection<OrganizationConformancePackStatus.Builder> getOrganizationConformancePackStatuses() {
            return this.organizationConformancePackStatuses != null ? (Collection)this.organizationConformancePackStatuses.stream().map(OrganizationConformancePackStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationConformancePackStatuses(Collection<OrganizationConformancePackStatus> organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses = OrganizationConformancePackStatusesCopier.copy(organizationConformancePackStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackStatuses(OrganizationConformancePackStatus ... organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses(Arrays.asList(organizationConformancePackStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackStatuses(Consumer<OrganizationConformancePackStatus.Builder> ... organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses(Stream.of(organizationConformancePackStatuses).map(c -> (OrganizationConformancePackStatus)((OrganizationConformancePackStatus.Builder)OrganizationConformancePackStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationConformancePackStatuses(Collection<OrganizationConformancePackStatus.BuilderImpl> organizationConformancePackStatuses) {
            this.organizationConformancePackStatuses = OrganizationConformancePackStatusesCopier.copyFromBuilder(organizationConformancePackStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeOrganizationConformancePackStatusesResponse build() {
            return new DescribeOrganizationConformancePackStatusesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConformancePackStatusesResponse> {
        public Builder organizationConformancePackStatuses(Collection<OrganizationConformancePackStatus> var1);

        public Builder organizationConformancePackStatuses(OrganizationConformancePackStatus ... var1);

        public Builder organizationConformancePackStatuses(Consumer<OrganizationConformancePackStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

