/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregateComplianceByConfigRule;
import software.amazon.awssdk.services.config.model.AggregateComplianceByConfigRuleListCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAggregateComplianceByConfigRulesResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeAggregateComplianceByConfigRulesResponse> {
    private static final SdkField<List<AggregateComplianceByConfigRule>> AGGREGATE_COMPLIANCE_BY_CONFIG_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAggregateComplianceByConfigRulesResponse.getter(DescribeAggregateComplianceByConfigRulesResponse::aggregateComplianceByConfigRules)).setter(DescribeAggregateComplianceByConfigRulesResponse.setter(Builder::aggregateComplianceByConfigRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateComplianceByConfigRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregateComplianceByConfigRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAggregateComplianceByConfigRulesResponse.getter(DescribeAggregateComplianceByConfigRulesResponse::nextToken)).setter(DescribeAggregateComplianceByConfigRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATE_COMPLIANCE_BY_CONFIG_RULES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AggregateComplianceByConfigRule> aggregateComplianceByConfigRules;
    private final String nextToken;

    private DescribeAggregateComplianceByConfigRulesResponse(BuilderImpl builder) {
        super(builder);
        this.aggregateComplianceByConfigRules = builder.aggregateComplianceByConfigRules;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAggregateComplianceByConfigRules() {
        return this.aggregateComplianceByConfigRules != null && !(this.aggregateComplianceByConfigRules instanceof SdkAutoConstructList);
    }

    public List<AggregateComplianceByConfigRule> aggregateComplianceByConfigRules() {
        return this.aggregateComplianceByConfigRules;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateComplianceByConfigRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAggregateComplianceByConfigRulesResponse)) {
            return false;
        }
        DescribeAggregateComplianceByConfigRulesResponse other = (DescribeAggregateComplianceByConfigRulesResponse)((Object)obj);
        return Objects.equals(this.aggregateComplianceByConfigRules(), other.aggregateComplianceByConfigRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAggregateComplianceByConfigRulesResponse").add("AggregateComplianceByConfigRules", this.aggregateComplianceByConfigRules()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregateComplianceByConfigRules": {
                return Optional.ofNullable(clazz.cast(this.aggregateComplianceByConfigRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAggregateComplianceByConfigRulesResponse, T> g) {
        return obj -> g.apply((DescribeAggregateComplianceByConfigRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<AggregateComplianceByConfigRule> aggregateComplianceByConfigRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAggregateComplianceByConfigRulesResponse model) {
            super(model);
            this.aggregateComplianceByConfigRules(model.aggregateComplianceByConfigRules);
            this.nextToken(model.nextToken);
        }

        public final Collection<AggregateComplianceByConfigRule.Builder> getAggregateComplianceByConfigRules() {
            return this.aggregateComplianceByConfigRules != null ? (Collection)this.aggregateComplianceByConfigRules.stream().map(AggregateComplianceByConfigRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregateComplianceByConfigRules(Collection<AggregateComplianceByConfigRule> aggregateComplianceByConfigRules) {
            this.aggregateComplianceByConfigRules = AggregateComplianceByConfigRuleListCopier.copy(aggregateComplianceByConfigRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateComplianceByConfigRules(AggregateComplianceByConfigRule ... aggregateComplianceByConfigRules) {
            this.aggregateComplianceByConfigRules(Arrays.asList(aggregateComplianceByConfigRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateComplianceByConfigRules(Consumer<AggregateComplianceByConfigRule.Builder> ... aggregateComplianceByConfigRules) {
            this.aggregateComplianceByConfigRules(Stream.of(aggregateComplianceByConfigRules).map(c -> (AggregateComplianceByConfigRule)((AggregateComplianceByConfigRule.Builder)AggregateComplianceByConfigRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregateComplianceByConfigRules(Collection<AggregateComplianceByConfigRule.BuilderImpl> aggregateComplianceByConfigRules) {
            this.aggregateComplianceByConfigRules = AggregateComplianceByConfigRuleListCopier.copyFromBuilder(aggregateComplianceByConfigRules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAggregateComplianceByConfigRulesResponse build() {
            return new DescribeAggregateComplianceByConfigRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAggregateComplianceByConfigRulesResponse> {
        public Builder aggregateComplianceByConfigRules(Collection<AggregateComplianceByConfigRule> var1);

        public Builder aggregateComplianceByConfigRules(AggregateComplianceByConfigRule ... var1);

        public Builder aggregateComplianceByConfigRules(Consumer<AggregateComplianceByConfigRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

