/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.DeliveryChannel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDeliveryChannelRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutDeliveryChannelRequest> {
    private static final SdkField<DeliveryChannel> DELIVERY_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutDeliveryChannelRequest.getter(PutDeliveryChannelRequest::deliveryChannel)).setter(PutDeliveryChannelRequest.setter(Builder::deliveryChannel)).constructor(DeliveryChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryChannel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_CHANNEL_FIELD));
    private final DeliveryChannel deliveryChannel;

    private PutDeliveryChannelRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryChannel = builder.deliveryChannel;
    }

    public DeliveryChannel deliveryChannel() {
        return this.deliveryChannel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryChannel());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeliveryChannelRequest)) {
            return false;
        }
        PutDeliveryChannelRequest other = (PutDeliveryChannelRequest)((Object)obj);
        return Objects.equals(this.deliveryChannel(), other.deliveryChannel());
    }

    public String toString() {
        return ToString.builder((String)"PutDeliveryChannelRequest").add("DeliveryChannel", (Object)this.deliveryChannel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryChannel": {
                return Optional.ofNullable(clazz.cast(this.deliveryChannel()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDeliveryChannelRequest, T> g) {
        return obj -> g.apply((PutDeliveryChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private DeliveryChannel deliveryChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeliveryChannelRequest model) {
            super(model);
            this.deliveryChannel(model.deliveryChannel);
        }

        public final DeliveryChannel.Builder getDeliveryChannel() {
            return this.deliveryChannel != null ? this.deliveryChannel.toBuilder() : null;
        }

        @Override
        public final Builder deliveryChannel(DeliveryChannel deliveryChannel) {
            this.deliveryChannel = deliveryChannel;
            return this;
        }

        public final void setDeliveryChannel(DeliveryChannel.BuilderImpl deliveryChannel) {
            this.deliveryChannel = deliveryChannel != null ? deliveryChannel.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDeliveryChannelRequest build() {
            return new PutDeliveryChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDeliveryChannelRequest> {
        public Builder deliveryChannel(DeliveryChannel var1);

        default public Builder deliveryChannel(Consumer<DeliveryChannel.Builder> deliveryChannel) {
            return this.deliveryChannel((DeliveryChannel)((DeliveryChannel.Builder)DeliveryChannel.builder().applyMutation(deliveryChannel)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

