/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.services.config.model.ResourceTypesScopeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationManagedRuleMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationManagedRuleMetadata> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationManagedRuleMetadata.getter(OrganizationManagedRuleMetadata::description)).setter(OrganizationManagedRuleMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> RULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationManagedRuleMetadata.getter(OrganizationManagedRuleMetadata::ruleIdentifier)).setter(OrganizationManagedRuleMetadata.setter(Builder::ruleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleIdentifier").build()}).build();
    private static final SdkField<String> INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationManagedRuleMetadata.getter(OrganizationManagedRuleMetadata::inputParameters)).setter(OrganizationManagedRuleMetadata.setter(Builder::inputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputParameters").build()}).build();
    private static final SdkField<String> MAXIMUM_EXECUTION_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationManagedRuleMetadata.getter(OrganizationManagedRuleMetadata::maximumExecutionFrequencyAsString)).setter(OrganizationManagedRuleMetadata.setter(Builder::maximumExecutionFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionFrequency").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrganizationManagedRuleMetadata.getter(OrganizationManagedRuleMetadata::resourceTypesScope)).setter(OrganizationManagedRuleMetadata.setter(Builder::resourceTypesScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypesScope").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ID_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationManagedRuleMetadata.getter(OrganizationManagedRuleMetadata::resourceIdScope)).setter(OrganizationManagedRuleMetadata.setter(Builder::resourceIdScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdScope").build()}).build();
    private static final SdkField<String> TAG_KEY_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationManagedRuleMetadata.getter(OrganizationManagedRuleMetadata::tagKeyScope)).setter(OrganizationManagedRuleMetadata.setter(Builder::tagKeyScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeyScope").build()}).build();
    private static final SdkField<String> TAG_VALUE_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationManagedRuleMetadata.getter(OrganizationManagedRuleMetadata::tagValueScope)).setter(OrganizationManagedRuleMetadata.setter(Builder::tagValueScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValueScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, RULE_IDENTIFIER_FIELD, INPUT_PARAMETERS_FIELD, MAXIMUM_EXECUTION_FREQUENCY_FIELD, RESOURCE_TYPES_SCOPE_FIELD, RESOURCE_ID_SCOPE_FIELD, TAG_KEY_SCOPE_FIELD, TAG_VALUE_SCOPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String ruleIdentifier;
    private final String inputParameters;
    private final String maximumExecutionFrequency;
    private final List<String> resourceTypesScope;
    private final String resourceIdScope;
    private final String tagKeyScope;
    private final String tagValueScope;

    private OrganizationManagedRuleMetadata(BuilderImpl builder) {
        this.description = builder.description;
        this.ruleIdentifier = builder.ruleIdentifier;
        this.inputParameters = builder.inputParameters;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
        this.resourceTypesScope = builder.resourceTypesScope;
        this.resourceIdScope = builder.resourceIdScope;
        this.tagKeyScope = builder.tagKeyScope;
        this.tagValueScope = builder.tagValueScope;
    }

    public String description() {
        return this.description;
    }

    public String ruleIdentifier() {
        return this.ruleIdentifier;
    }

    public String inputParameters() {
        return this.inputParameters;
    }

    public MaximumExecutionFrequency maximumExecutionFrequency() {
        return MaximumExecutionFrequency.fromValue(this.maximumExecutionFrequency);
    }

    public String maximumExecutionFrequencyAsString() {
        return this.maximumExecutionFrequency;
    }

    public boolean hasResourceTypesScope() {
        return this.resourceTypesScope != null && !(this.resourceTypesScope instanceof SdkAutoConstructList);
    }

    public List<String> resourceTypesScope() {
        return this.resourceTypesScope;
    }

    public String resourceIdScope() {
        return this.resourceIdScope;
    }

    public String tagKeyScope() {
        return this.tagKeyScope;
    }

    public String tagValueScope() {
        return this.tagValueScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumExecutionFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypesScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeyScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValueScope());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationManagedRuleMetadata)) {
            return false;
        }
        OrganizationManagedRuleMetadata other = (OrganizationManagedRuleMetadata)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.ruleIdentifier(), other.ruleIdentifier()) && Objects.equals(this.inputParameters(), other.inputParameters()) && Objects.equals(this.maximumExecutionFrequencyAsString(), other.maximumExecutionFrequencyAsString()) && Objects.equals(this.resourceTypesScope(), other.resourceTypesScope()) && Objects.equals(this.resourceIdScope(), other.resourceIdScope()) && Objects.equals(this.tagKeyScope(), other.tagKeyScope()) && Objects.equals(this.tagValueScope(), other.tagValueScope());
    }

    public String toString() {
        return ToString.builder((String)"OrganizationManagedRuleMetadata").add("Description", (Object)this.description()).add("RuleIdentifier", (Object)this.ruleIdentifier()).add("InputParameters", (Object)this.inputParameters()).add("MaximumExecutionFrequency", (Object)this.maximumExecutionFrequencyAsString()).add("ResourceTypesScope", this.resourceTypesScope()).add("ResourceIdScope", (Object)this.resourceIdScope()).add("TagKeyScope", (Object)this.tagKeyScope()).add("TagValueScope", (Object)this.tagValueScope()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RuleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ruleIdentifier()));
            }
            case "InputParameters": {
                return Optional.ofNullable(clazz.cast(this.inputParameters()));
            }
            case "MaximumExecutionFrequency": {
                return Optional.ofNullable(clazz.cast(this.maximumExecutionFrequencyAsString()));
            }
            case "ResourceTypesScope": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesScope()));
            }
            case "ResourceIdScope": {
                return Optional.ofNullable(clazz.cast(this.resourceIdScope()));
            }
            case "TagKeyScope": {
                return Optional.ofNullable(clazz.cast(this.tagKeyScope()));
            }
            case "TagValueScope": {
                return Optional.ofNullable(clazz.cast(this.tagValueScope()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationManagedRuleMetadata, T> g) {
        return obj -> g.apply((OrganizationManagedRuleMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String ruleIdentifier;
        private String inputParameters;
        private String maximumExecutionFrequency;
        private List<String> resourceTypesScope = DefaultSdkAutoConstructList.getInstance();
        private String resourceIdScope;
        private String tagKeyScope;
        private String tagValueScope;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationManagedRuleMetadata model) {
            this.description(model.description);
            this.ruleIdentifier(model.ruleIdentifier);
            this.inputParameters(model.inputParameters);
            this.maximumExecutionFrequency(model.maximumExecutionFrequency);
            this.resourceTypesScope(model.resourceTypesScope);
            this.resourceIdScope(model.resourceIdScope);
            this.tagKeyScope(model.tagKeyScope);
            this.tagValueScope(model.tagValueScope);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRuleIdentifier() {
            return this.ruleIdentifier;
        }

        @Override
        public final Builder ruleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
            return this;
        }

        public final void setRuleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
        }

        public final String getInputParameters() {
            return this.inputParameters;
        }

        @Override
        public final Builder inputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public final void setInputParameters(String inputParameters) {
            this.inputParameters = inputParameters;
        }

        public final String getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency == null ? null : maximumExecutionFrequency.toString());
            return this;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        public final Collection<String> getResourceTypesScope() {
            return this.resourceTypesScope;
        }

        @Override
        public final Builder resourceTypesScope(Collection<String> resourceTypesScope) {
            this.resourceTypesScope = ResourceTypesScopeCopier.copy(resourceTypesScope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesScope(String ... resourceTypesScope) {
            this.resourceTypesScope(Arrays.asList(resourceTypesScope));
            return this;
        }

        public final void setResourceTypesScope(Collection<String> resourceTypesScope) {
            this.resourceTypesScope = ResourceTypesScopeCopier.copy(resourceTypesScope);
        }

        public final String getResourceIdScope() {
            return this.resourceIdScope;
        }

        @Override
        public final Builder resourceIdScope(String resourceIdScope) {
            this.resourceIdScope = resourceIdScope;
            return this;
        }

        public final void setResourceIdScope(String resourceIdScope) {
            this.resourceIdScope = resourceIdScope;
        }

        public final String getTagKeyScope() {
            return this.tagKeyScope;
        }

        @Override
        public final Builder tagKeyScope(String tagKeyScope) {
            this.tagKeyScope = tagKeyScope;
            return this;
        }

        public final void setTagKeyScope(String tagKeyScope) {
            this.tagKeyScope = tagKeyScope;
        }

        public final String getTagValueScope() {
            return this.tagValueScope;
        }

        @Override
        public final Builder tagValueScope(String tagValueScope) {
            this.tagValueScope = tagValueScope;
            return this;
        }

        public final void setTagValueScope(String tagValueScope) {
            this.tagValueScope = tagValueScope;
        }

        public OrganizationManagedRuleMetadata build() {
            return new OrganizationManagedRuleMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationManagedRuleMetadata> {
        public Builder description(String var1);

        public Builder ruleIdentifier(String var1);

        public Builder inputParameters(String var1);

        public Builder maximumExecutionFrequency(String var1);

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency var1);

        public Builder resourceTypesScope(Collection<String> var1);

        public Builder resourceTypesScope(String ... var1);

        public Builder resourceIdScope(String var1);

        public Builder tagKeyScope(String var1);

        public Builder tagValueScope(String var1);
    }
}

