/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConformancePackComplianceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConformancePackComplianceSummary> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConformancePackComplianceSummary.getter(ConformancePackComplianceSummary::conformancePackName)).setter(ConformancePackComplianceSummary.setter(Builder::conformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build()}).build();
    private static final SdkField<String> CONFORMANCE_PACK_COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConformancePackComplianceSummary.getter(ConformancePackComplianceSummary::conformancePackComplianceStatusAsString)).setter(ConformancePackComplianceSummary.setter(Builder::conformancePackComplianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackComplianceStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD, CONFORMANCE_PACK_COMPLIANCE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String conformancePackName;
    private final String conformancePackComplianceStatus;

    private ConformancePackComplianceSummary(BuilderImpl builder) {
        this.conformancePackName = builder.conformancePackName;
        this.conformancePackComplianceStatus = builder.conformancePackComplianceStatus;
    }

    public String conformancePackName() {
        return this.conformancePackName;
    }

    public ConformancePackComplianceType conformancePackComplianceStatus() {
        return ConformancePackComplianceType.fromValue(this.conformancePackComplianceStatus);
    }

    public String conformancePackComplianceStatusAsString() {
        return this.conformancePackComplianceStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackComplianceStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackComplianceSummary)) {
            return false;
        }
        ConformancePackComplianceSummary other = (ConformancePackComplianceSummary)obj;
        return Objects.equals(this.conformancePackName(), other.conformancePackName()) && Objects.equals(this.conformancePackComplianceStatusAsString(), other.conformancePackComplianceStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ConformancePackComplianceSummary").add("ConformancePackName", (Object)this.conformancePackName()).add("ConformancePackComplianceStatus", (Object)this.conformancePackComplianceStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.conformancePackName()));
            }
            case "ConformancePackComplianceStatus": {
                return Optional.ofNullable(clazz.cast(this.conformancePackComplianceStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackComplianceSummary, T> g) {
        return obj -> g.apply((ConformancePackComplianceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conformancePackName;
        private String conformancePackComplianceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackComplianceSummary model) {
            this.conformancePackName(model.conformancePackName);
            this.conformancePackComplianceStatus(model.conformancePackComplianceStatus);
        }

        public final String getConformancePackName() {
            return this.conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        public final String getConformancePackComplianceStatus() {
            return this.conformancePackComplianceStatus;
        }

        @Override
        public final Builder conformancePackComplianceStatus(String conformancePackComplianceStatus) {
            this.conformancePackComplianceStatus = conformancePackComplianceStatus;
            return this;
        }

        @Override
        public final Builder conformancePackComplianceStatus(ConformancePackComplianceType conformancePackComplianceStatus) {
            this.conformancePackComplianceStatus(conformancePackComplianceStatus == null ? null : conformancePackComplianceStatus.toString());
            return this;
        }

        public final void setConformancePackComplianceStatus(String conformancePackComplianceStatus) {
            this.conformancePackComplianceStatus = conformancePackComplianceStatus;
        }

        public ConformancePackComplianceSummary build() {
            return new ConformancePackComplianceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConformancePackComplianceSummary> {
        public Builder conformancePackName(String var1);

        public Builder conformancePackComplianceStatus(String var1);

        public Builder conformancePackComplianceStatus(ConformancePackComplianceType var1);
    }
}

