/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConformancePackState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConformancePackStatusDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConformancePackStatusDetail> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConformancePackStatusDetail.getter(ConformancePackStatusDetail::conformancePackName)).setter(ConformancePackStatusDetail.setter(Builder::conformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build()}).build();
    private static final SdkField<String> CONFORMANCE_PACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConformancePackStatusDetail.getter(ConformancePackStatusDetail::conformancePackId)).setter(ConformancePackStatusDetail.setter(Builder::conformancePackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackId").build()}).build();
    private static final SdkField<String> CONFORMANCE_PACK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConformancePackStatusDetail.getter(ConformancePackStatusDetail::conformancePackArn)).setter(ConformancePackStatusDetail.setter(Builder::conformancePackArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackArn").build()}).build();
    private static final SdkField<String> CONFORMANCE_PACK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConformancePackStatusDetail.getter(ConformancePackStatusDetail::conformancePackStateAsString)).setter(ConformancePackStatusDetail.setter(Builder::conformancePackState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackState").build()}).build();
    private static final SdkField<String> STACK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConformancePackStatusDetail.getter(ConformancePackStatusDetail::stackArn)).setter(ConformancePackStatusDetail.setter(Builder::stackArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackArn").build()}).build();
    private static final SdkField<String> CONFORMANCE_PACK_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConformancePackStatusDetail.getter(ConformancePackStatusDetail::conformancePackStatusReason)).setter(ConformancePackStatusDetail.setter(Builder::conformancePackStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackStatusReason").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_REQUESTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ConformancePackStatusDetail.getter(ConformancePackStatusDetail::lastUpdateRequestedTime)).setter(ConformancePackStatusDetail.setter(Builder::lastUpdateRequestedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateRequestedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_COMPLETED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ConformancePackStatusDetail.getter(ConformancePackStatusDetail::lastUpdateCompletedTime)).setter(ConformancePackStatusDetail.setter(Builder::lastUpdateCompletedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateCompletedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD, CONFORMANCE_PACK_ID_FIELD, CONFORMANCE_PACK_ARN_FIELD, CONFORMANCE_PACK_STATE_FIELD, STACK_ARN_FIELD, CONFORMANCE_PACK_STATUS_REASON_FIELD, LAST_UPDATE_REQUESTED_TIME_FIELD, LAST_UPDATE_COMPLETED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String conformancePackName;
    private final String conformancePackId;
    private final String conformancePackArn;
    private final String conformancePackState;
    private final String stackArn;
    private final String conformancePackStatusReason;
    private final Instant lastUpdateRequestedTime;
    private final Instant lastUpdateCompletedTime;

    private ConformancePackStatusDetail(BuilderImpl builder) {
        this.conformancePackName = builder.conformancePackName;
        this.conformancePackId = builder.conformancePackId;
        this.conformancePackArn = builder.conformancePackArn;
        this.conformancePackState = builder.conformancePackState;
        this.stackArn = builder.stackArn;
        this.conformancePackStatusReason = builder.conformancePackStatusReason;
        this.lastUpdateRequestedTime = builder.lastUpdateRequestedTime;
        this.lastUpdateCompletedTime = builder.lastUpdateCompletedTime;
    }

    public String conformancePackName() {
        return this.conformancePackName;
    }

    public String conformancePackId() {
        return this.conformancePackId;
    }

    public String conformancePackArn() {
        return this.conformancePackArn;
    }

    public ConformancePackState conformancePackState() {
        return ConformancePackState.fromValue(this.conformancePackState);
    }

    public String conformancePackStateAsString() {
        return this.conformancePackState;
    }

    public String stackArn() {
        return this.stackArn;
    }

    public String conformancePackStatusReason() {
        return this.conformancePackStatusReason;
    }

    public Instant lastUpdateRequestedTime() {
        return this.lastUpdateRequestedTime;
    }

    public Instant lastUpdateCompletedTime() {
        return this.lastUpdateCompletedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateRequestedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateCompletedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackStatusDetail)) {
            return false;
        }
        ConformancePackStatusDetail other = (ConformancePackStatusDetail)obj;
        return Objects.equals(this.conformancePackName(), other.conformancePackName()) && Objects.equals(this.conformancePackId(), other.conformancePackId()) && Objects.equals(this.conformancePackArn(), other.conformancePackArn()) && Objects.equals(this.conformancePackStateAsString(), other.conformancePackStateAsString()) && Objects.equals(this.stackArn(), other.stackArn()) && Objects.equals(this.conformancePackStatusReason(), other.conformancePackStatusReason()) && Objects.equals(this.lastUpdateRequestedTime(), other.lastUpdateRequestedTime()) && Objects.equals(this.lastUpdateCompletedTime(), other.lastUpdateCompletedTime());
    }

    public String toString() {
        return ToString.builder((String)"ConformancePackStatusDetail").add("ConformancePackName", (Object)this.conformancePackName()).add("ConformancePackId", (Object)this.conformancePackId()).add("ConformancePackArn", (Object)this.conformancePackArn()).add("ConformancePackState", (Object)this.conformancePackStateAsString()).add("StackArn", (Object)this.stackArn()).add("ConformancePackStatusReason", (Object)this.conformancePackStatusReason()).add("LastUpdateRequestedTime", (Object)this.lastUpdateRequestedTime()).add("LastUpdateCompletedTime", (Object)this.lastUpdateCompletedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.conformancePackName()));
            }
            case "ConformancePackId": {
                return Optional.ofNullable(clazz.cast(this.conformancePackId()));
            }
            case "ConformancePackArn": {
                return Optional.ofNullable(clazz.cast(this.conformancePackArn()));
            }
            case "ConformancePackState": {
                return Optional.ofNullable(clazz.cast(this.conformancePackStateAsString()));
            }
            case "StackArn": {
                return Optional.ofNullable(clazz.cast(this.stackArn()));
            }
            case "ConformancePackStatusReason": {
                return Optional.ofNullable(clazz.cast(this.conformancePackStatusReason()));
            }
            case "LastUpdateRequestedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateRequestedTime()));
            }
            case "LastUpdateCompletedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateCompletedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackStatusDetail, T> g) {
        return obj -> g.apply((ConformancePackStatusDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conformancePackName;
        private String conformancePackId;
        private String conformancePackArn;
        private String conformancePackState;
        private String stackArn;
        private String conformancePackStatusReason;
        private Instant lastUpdateRequestedTime;
        private Instant lastUpdateCompletedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackStatusDetail model) {
            this.conformancePackName(model.conformancePackName);
            this.conformancePackId(model.conformancePackId);
            this.conformancePackArn(model.conformancePackArn);
            this.conformancePackState(model.conformancePackState);
            this.stackArn(model.stackArn);
            this.conformancePackStatusReason(model.conformancePackStatusReason);
            this.lastUpdateRequestedTime(model.lastUpdateRequestedTime);
            this.lastUpdateCompletedTime(model.lastUpdateCompletedTime);
        }

        public final String getConformancePackName() {
            return this.conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        public final String getConformancePackId() {
            return this.conformancePackId;
        }

        @Override
        public final Builder conformancePackId(String conformancePackId) {
            this.conformancePackId = conformancePackId;
            return this;
        }

        public final void setConformancePackId(String conformancePackId) {
            this.conformancePackId = conformancePackId;
        }

        public final String getConformancePackArn() {
            return this.conformancePackArn;
        }

        @Override
        public final Builder conformancePackArn(String conformancePackArn) {
            this.conformancePackArn = conformancePackArn;
            return this;
        }

        public final void setConformancePackArn(String conformancePackArn) {
            this.conformancePackArn = conformancePackArn;
        }

        public final String getConformancePackState() {
            return this.conformancePackState;
        }

        @Override
        public final Builder conformancePackState(String conformancePackState) {
            this.conformancePackState = conformancePackState;
            return this;
        }

        @Override
        public final Builder conformancePackState(ConformancePackState conformancePackState) {
            this.conformancePackState(conformancePackState == null ? null : conformancePackState.toString());
            return this;
        }

        public final void setConformancePackState(String conformancePackState) {
            this.conformancePackState = conformancePackState;
        }

        public final String getStackArn() {
            return this.stackArn;
        }

        @Override
        public final Builder stackArn(String stackArn) {
            this.stackArn = stackArn;
            return this;
        }

        public final void setStackArn(String stackArn) {
            this.stackArn = stackArn;
        }

        public final String getConformancePackStatusReason() {
            return this.conformancePackStatusReason;
        }

        @Override
        public final Builder conformancePackStatusReason(String conformancePackStatusReason) {
            this.conformancePackStatusReason = conformancePackStatusReason;
            return this;
        }

        public final void setConformancePackStatusReason(String conformancePackStatusReason) {
            this.conformancePackStatusReason = conformancePackStatusReason;
        }

        public final Instant getLastUpdateRequestedTime() {
            return this.lastUpdateRequestedTime;
        }

        @Override
        public final Builder lastUpdateRequestedTime(Instant lastUpdateRequestedTime) {
            this.lastUpdateRequestedTime = lastUpdateRequestedTime;
            return this;
        }

        public final void setLastUpdateRequestedTime(Instant lastUpdateRequestedTime) {
            this.lastUpdateRequestedTime = lastUpdateRequestedTime;
        }

        public final Instant getLastUpdateCompletedTime() {
            return this.lastUpdateCompletedTime;
        }

        @Override
        public final Builder lastUpdateCompletedTime(Instant lastUpdateCompletedTime) {
            this.lastUpdateCompletedTime = lastUpdateCompletedTime;
            return this;
        }

        public final void setLastUpdateCompletedTime(Instant lastUpdateCompletedTime) {
            this.lastUpdateCompletedTime = lastUpdateCompletedTime;
        }

        public ConformancePackStatusDetail build() {
            return new ConformancePackStatusDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConformancePackStatusDetail> {
        public Builder conformancePackName(String var1);

        public Builder conformancePackId(String var1);

        public Builder conformancePackArn(String var1);

        public Builder conformancePackState(String var1);

        public Builder conformancePackState(ConformancePackState var1);

        public Builder stackArn(String var1);

        public Builder conformancePackStatusReason(String var1);

        public Builder lastUpdateRequestedTime(Instant var1);

        public Builder lastUpdateCompletedTime(Instant var1);
    }
}

