/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.RemediationExecutionState;
import software.amazon.awssdk.services.config.model.RemediationExecutionStep;
import software.amazon.awssdk.services.config.model.RemediationExecutionStepsCopier;
import software.amazon.awssdk.services.config.model.ResourceKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemediationExecutionStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemediationExecutionStatus> {
    private static final SdkField<ResourceKey> RESOURCE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RemediationExecutionStatus.getter(RemediationExecutionStatus::resourceKey)).setter(RemediationExecutionStatus.setter(Builder::resourceKey)).constructor(ResourceKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKey").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemediationExecutionStatus.getter(RemediationExecutionStatus::stateAsString)).setter(RemediationExecutionStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<RemediationExecutionStep>> STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RemediationExecutionStatus.getter(RemediationExecutionStatus::stepDetails)).setter(RemediationExecutionStatus.setter(Builder::stepDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemediationExecutionStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> INVOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RemediationExecutionStatus.getter(RemediationExecutionStatus::invocationTime)).setter(RemediationExecutionStatus.setter(Builder::invocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RemediationExecutionStatus.getter(RemediationExecutionStatus::lastUpdatedTime)).setter(RemediationExecutionStatus.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_KEY_FIELD, STATE_FIELD, STEP_DETAILS_FIELD, INVOCATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResourceKey resourceKey;
    private final String state;
    private final List<RemediationExecutionStep> stepDetails;
    private final Instant invocationTime;
    private final Instant lastUpdatedTime;

    private RemediationExecutionStatus(BuilderImpl builder) {
        this.resourceKey = builder.resourceKey;
        this.state = builder.state;
        this.stepDetails = builder.stepDetails;
        this.invocationTime = builder.invocationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public ResourceKey resourceKey() {
        return this.resourceKey;
    }

    public RemediationExecutionState state() {
        return RemediationExecutionState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public boolean hasStepDetails() {
        return this.stepDetails != null && !(this.stepDetails instanceof SdkAutoConstructList);
    }

    public List<RemediationExecutionStep> stepDetails() {
        return this.stepDetails;
    }

    public Instant invocationTime() {
        return this.invocationTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationExecutionStatus)) {
            return false;
        }
        RemediationExecutionStatus other = (RemediationExecutionStatus)obj;
        return Objects.equals(this.resourceKey(), other.resourceKey()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stepDetails(), other.stepDetails()) && Objects.equals(this.invocationTime(), other.invocationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public String toString() {
        return ToString.builder((String)"RemediationExecutionStatus").add("ResourceKey", (Object)this.resourceKey()).add("State", (Object)this.stateAsString()).add("StepDetails", this.stepDetails()).add("InvocationTime", (Object)this.invocationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceKey": {
                return Optional.ofNullable(clazz.cast(this.resourceKey()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StepDetails": {
                return Optional.ofNullable(clazz.cast(this.stepDetails()));
            }
            case "InvocationTime": {
                return Optional.ofNullable(clazz.cast(this.invocationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationExecutionStatus, T> g) {
        return obj -> g.apply((RemediationExecutionStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceKey resourceKey;
        private String state;
        private List<RemediationExecutionStep> stepDetails = DefaultSdkAutoConstructList.getInstance();
        private Instant invocationTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationExecutionStatus model) {
            this.resourceKey(model.resourceKey);
            this.state(model.state);
            this.stepDetails(model.stepDetails);
            this.invocationTime(model.invocationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final ResourceKey.Builder getResourceKey() {
            return this.resourceKey != null ? this.resourceKey.toBuilder() : null;
        }

        @Override
        public final Builder resourceKey(ResourceKey resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        public final void setResourceKey(ResourceKey.BuilderImpl resourceKey) {
            this.resourceKey = resourceKey != null ? resourceKey.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RemediationExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<RemediationExecutionStep.Builder> getStepDetails() {
            return this.stepDetails != null ? (Collection)this.stepDetails.stream().map(RemediationExecutionStep::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stepDetails(Collection<RemediationExecutionStep> stepDetails) {
            this.stepDetails = RemediationExecutionStepsCopier.copy(stepDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepDetails(RemediationExecutionStep ... stepDetails) {
            this.stepDetails(Arrays.asList(stepDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepDetails(Consumer<RemediationExecutionStep.Builder> ... stepDetails) {
            this.stepDetails(Stream.of(stepDetails).map(c -> (RemediationExecutionStep)((RemediationExecutionStep.Builder)RemediationExecutionStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStepDetails(Collection<RemediationExecutionStep.BuilderImpl> stepDetails) {
            this.stepDetails = RemediationExecutionStepsCopier.copyFromBuilder(stepDetails);
        }

        public final Instant getInvocationTime() {
            return this.invocationTime;
        }

        @Override
        public final Builder invocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
            return this;
        }

        public final void setInvocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public RemediationExecutionStatus build() {
            return new RemediationExecutionStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemediationExecutionStatus> {
        public Builder resourceKey(ResourceKey var1);

        default public Builder resourceKey(Consumer<ResourceKey.Builder> resourceKey) {
            return this.resourceKey((ResourceKey)((ResourceKey.Builder)ResourceKey.builder().applyMutation(resourceKey)).build());
        }

        public Builder state(String var1);

        public Builder state(RemediationExecutionState var1);

        public Builder stepDetails(Collection<RemediationExecutionStep> var1);

        public Builder stepDetails(RemediationExecutionStep ... var1);

        public Builder stepDetails(Consumer<RemediationExecutionStep.Builder> ... var1);

        public Builder invocationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

