/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.Evaluation;
import software.amazon.awssdk.services.config.model.EvaluationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutEvaluationsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, PutEvaluationsResponse> {
    private final List<Evaluation> failedEvaluations;

    private PutEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEvaluations = builder.failedEvaluations;
    }

    public List<Evaluation> failedEvaluations() {
        return this.failedEvaluations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failedEvaluations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEvaluationsResponse)) {
            return false;
        }
        PutEvaluationsResponse other = (PutEvaluationsResponse)((Object)obj);
        return Objects.equals(this.failedEvaluations(), other.failedEvaluations());
    }

    public String toString() {
        return ToString.builder((String)"PutEvaluationsResponse").add("FailedEvaluations", this.failedEvaluations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedEvaluations": {
                return Optional.of(clazz.cast(this.failedEvaluations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<Evaluation> failedEvaluations;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEvaluationsResponse model) {
            this.failedEvaluations(model.failedEvaluations);
        }

        public final Collection<Evaluation.Builder> getFailedEvaluations() {
            return this.failedEvaluations != null ? (Collection)this.failedEvaluations.stream().map(Evaluation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedEvaluations(Collection<Evaluation> failedEvaluations) {
            this.failedEvaluations = EvaluationsCopier.copy(failedEvaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEvaluations(Evaluation ... failedEvaluations) {
            this.failedEvaluations(Arrays.asList(failedEvaluations));
            return this;
        }

        public final void setFailedEvaluations(Collection<Evaluation.BuilderImpl> failedEvaluations) {
            this.failedEvaluations = EvaluationsCopier.copyFromBuilder(failedEvaluations);
        }

        @Override
        public PutEvaluationsResponse build() {
            return new PutEvaluationsResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, PutEvaluationsResponse> {
        public Builder failedEvaluations(Collection<Evaluation> var1);

        public Builder failedEvaluations(Evaluation ... var1);
    }
}

