/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigurationItem;
import software.amazon.awssdk.services.config.model.ConfigurationItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetResourceConfigHistoryResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetResourceConfigHistoryResponse> {
    private final List<ConfigurationItem> configurationItems;
    private final String nextToken;

    private GetResourceConfigHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.configurationItems = builder.configurationItems;
        this.nextToken = builder.nextToken;
    }

    public List<ConfigurationItem> configurationItems() {
        return this.configurationItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigHistoryResponse)) {
            return false;
        }
        GetResourceConfigHistoryResponse other = (GetResourceConfigHistoryResponse)((Object)obj);
        return Objects.equals(this.configurationItems(), other.configurationItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetResourceConfigHistoryResponse").add("ConfigurationItems", this.configurationItems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurationItems": {
                return Optional.of(clazz.cast(this.configurationItems()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationItem> configurationItems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigHistoryResponse model) {
            this.configurationItems(model.configurationItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<ConfigurationItem.Builder> getConfigurationItems() {
            return this.configurationItems != null ? (Collection)this.configurationItems.stream().map(ConfigurationItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationItems(Collection<ConfigurationItem> configurationItems) {
            this.configurationItems = ConfigurationItemListCopier.copy(configurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationItems(ConfigurationItem ... configurationItems) {
            this.configurationItems(Arrays.asList(configurationItems));
            return this;
        }

        public final void setConfigurationItems(Collection<ConfigurationItem.BuilderImpl> configurationItems) {
            this.configurationItems = ConfigurationItemListCopier.copyFromBuilder(configurationItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetResourceConfigHistoryResponse build() {
            return new GetResourceConfigHistoryResponse(this);
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    CopyableBuilder<Builder, GetResourceConfigHistoryResponse> {
        public Builder configurationItems(Collection<ConfigurationItem> var1);

        public Builder configurationItems(ConfigurationItem ... var1);

        public Builder nextToken(String var1);
    }
}

